/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside;

import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.netty.util.CharsetUtil;
import javax.crypto.spec.SecretKeySpec;
import ratpack.guice.ConfigurableModule;
import ratpack.session.SessionStore;
import ratpack.session.clientside.ClientSideSessionConfig;
import ratpack.session.clientside.Crypto;
import ratpack.session.clientside.Signer;
import ratpack.session.clientside.internal.ClientSideSessionStore;
import ratpack.session.clientside.internal.DefaultCrypto;
import ratpack.session.clientside.internal.DefaultSigner;
import ratpack.session.clientside.internal.NoCrypto;

public class ClientSideSessionModule
extends ConfigurableModule<ClientSideSessionConfig> {
    protected void configure() {
        this.bind(SessionStore.class).to(ClientSideSessionStore.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    Signer signer(ClientSideSessionConfig config) {
        byte[] token = config.getSecretToken().getBytes(CharsetUtil.ISO_8859_1);
        return new DefaultSigner(new SecretKeySpec(token, config.getMacAlgorithm()));
    }

    @Provides
    @Singleton
    Crypto crypto(ClientSideSessionConfig config) {
        if (config.getSecretKey() == null || config.getCipherAlgorithm() == null) {
            return NoCrypto.INSTANCE;
        }
        return new DefaultCrypto(config.getSecretKey().getBytes(CharsetUtil.ISO_8859_1), config.getCipherAlgorithm());
    }
}

