/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import ratpack.core.handling.Context;
import ratpack.core.server.ServerConfig;
import ratpack.core.websocket.AutoCloseWebSocketHandler;
import ratpack.core.websocket.WebSocket;
import ratpack.core.websocket.WebSocketConnector;
import ratpack.core.websocket.WebSocketHandler;
import ratpack.core.websocket.internal.DefaultWebSocketConnector;
import ratpack.core.websocket.internal.WebSocketEngine;
import ratpack.core.websocket.internal.WebsocketBroadcastSubscriber;
import ratpack.exec.stream.Streams;
import ratpack.func.Function;

public abstract class WebSockets {
    public static <T> WebSocketConnector<T> websocket(Context context, Function<WebSocket, T> openAction) {
        return new DefaultWebSocketConnector<T>(context, openAction);
    }

    public static void websocket(Context context, WebSocketHandler<?> handler) {
        WebSocketEngine.connect(context, "/", ((ServerConfig)context.get(ServerConfig.class)).getMaxContentLength(), handler);
    }

    public static void websocketBroadcast(Context context, Publisher<String> broadcaster) {
        ByteBufAllocator bufferAllocator = (ByteBufAllocator)context.get(ByteBufAllocator.class);
        WebSockets.websocketByteBufBroadcast(context, (Publisher<ByteBuf>)Streams.map(broadcaster, s -> ByteBufUtil.encodeString((ByteBufAllocator)bufferAllocator, (CharBuffer)CharBuffer.wrap(s), (Charset)CharsetUtil.UTF_8)));
    }

    public static void websocketByteBufBroadcast(Context context, final Publisher<ByteBuf> broadcaster) {
        WebSockets.websocket(context, new AutoCloseWebSocketHandler<AutoCloseable>(){

            @Override
            public AutoCloseable onOpen(WebSocket webSocket) throws Exception {
                WebsocketBroadcastSubscriber subscriber = new WebsocketBroadcastSubscriber(webSocket);
                Streams.bindExec((Publisher)broadcaster, ReferenceCounted::release).subscribe((Subscriber)subscriber);
                return subscriber;
            }
        });
    }
}

