/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.path.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import ratpack.core.handling.Context;
import ratpack.core.handling.Handler;
import ratpack.core.handling.internal.ChainHandler;
import ratpack.core.path.PathBinder;
import ratpack.core.path.PathBinding;
import ratpack.core.path.internal.PathBindingStorage;

public class PathHandler
implements Handler {
    private static final int CACHE_SIZE = Integer.parseInt(System.getProperty("ratpack.cachesize.path", "10000"));
    private static final Handler POP_BINDING = ctx -> {
        ((PathBindingStorage)ctx.getExecution().get(PathBindingStorage.TYPE)).pop();
        ctx.next();
    };
    private final PathBinder binder;
    private final Handler[] handler;
    private final Cache<PathBinding, Optional<PathBinding>> cache = Caffeine.newBuilder().maximumSize((long)CACHE_SIZE).build();

    public PathHandler(PathBinder binder, Handler handler) {
        this.binder = binder;
        Handler[] unpacked = ChainHandler.unpack(handler);
        Handler[] withPop = new Handler[unpacked.length + 1];
        System.arraycopy(unpacked, 0, withPop, 0, unpacked.length);
        withPop[unpacked.length] = POP_BINDING;
        this.handler = withPop;
    }

    @Override
    public void handle(Context ctx) throws ExecutionException {
        PathBindingStorage pathBindings = (PathBindingStorage)ctx.getExecution().get(PathBindingStorage.TYPE);
        PathBinding pathBinding = (PathBinding)pathBindings.peek();
        Optional newBinding = (Optional)this.cache.get((Object)pathBinding, this.binder::bind);
        if (newBinding.isPresent()) {
            pathBindings.push((PathBinding)newBinding.get());
            ctx.insert(this.handler);
        } else {
            ctx.next();
        }
    }
}

