/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.path.internal;

import com.google.common.collect.ImmutableList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ratpack.core.path.PathBinder;
import ratpack.core.path.PathBinderBuilder;
import ratpack.core.path.internal.PathTokenType;
import ratpack.core.path.internal.TokenPathBinder;

public class DefaultPathBinderBuilder
implements PathBinderBuilder {
    private static final Pattern PLACEHOLDER = Pattern.compile("((?:^|/):(\\w+)\\??:([^/])+)|((?:^|/)::([^/])+)|((?:^|/):(\\w+)\\??)");
    private final ImmutableList.Builder<String> tokensBuilder = ImmutableList.builder();
    private final StringBuilder pattern = new StringBuilder();
    private final StringBuilder description = new StringBuilder();
    private boolean addedOptional;
    private boolean addedToken;

    @Override
    public PathBinderBuilder tokenWithPattern(String token, String pattern) {
        if (this.addedOptional) {
            throw new IllegalArgumentException(String.format("Cannot add mandatory parameter %s after optional parameters", token));
        }
        this.addedToken = true;
        this.tokensBuilder.add((Object)token);
        this.pattern.append(String.format("(?:(?:^|/)(%s))", pattern));
        this.appendDescriptionSegment(":").append(token).append(":").append(pattern);
        return this;
    }

    @Override
    public PathBinderBuilder optionalTokenWithPattern(String token, String pattern) {
        this.addedOptional = true;
        this.addedToken = true;
        this.tokensBuilder.add((Object)token);
        this.pattern.append(String.format("(?:(?:^|/)(%s))?", pattern));
        this.appendDescriptionSegment(":").append(token).append("?:").append(pattern);
        return this;
    }

    @Override
    public PathBinderBuilder token(String token) {
        if (this.addedOptional) {
            throw new IllegalArgumentException(String.format("Cannot add mandatory parameter %s after optional parameters", token));
        }
        this.addedToken = true;
        this.tokensBuilder.add((Object)token);
        this.pattern.append("(?:(?:^|/)([^/?&#]+))");
        this.appendDescriptionSegment(":").append(token);
        return this;
    }

    @Override
    public PathBinderBuilder optionalToken(String token) {
        this.addedOptional = true;
        this.addedToken = true;
        this.tokensBuilder.add((Object)token);
        this.pattern.append("(?:(?:^|/)([^/?&#]*))?");
        this.appendDescriptionSegment(":").append(token).append("?");
        return this;
    }

    @Override
    public PathBinderBuilder literalPattern(String pattern) {
        this.pattern.append("(?:(?:^|/)").append("(?:").append(pattern).append("))");
        this.appendDescriptionSegment("::").append(pattern);
        return this;
    }

    @Override
    public PathBinderBuilder literal(String literal) {
        this.pattern.append("\\Q").append(literal).append("\\E");
        this.description.append(literal);
        return this;
    }

    private StringBuilder appendDescriptionSegment(String segment) {
        if (this.description.length() > 0) {
            this.description.append("/");
        }
        return this.description.append(segment);
    }

    @Override
    public PathBinder build(boolean exhaustive) {
        String regex = (this.addedToken ? "(\\Q\\E" : "(") + this.pattern + (this.addedToken ? "\\Q\\E)" : ")") + (exhaustive ? "(?:/|$)" : "(?:/.*)?");
        Pattern compiled = Pattern.compile(regex);
        return new TokenPathBinder((ImmutableList<String>)this.tokensBuilder.build(), this.description.toString(), compiled);
    }

    public static PathBinder parse(String path, boolean exact) {
        DefaultPathBinderBuilder pathBinderBuilder = new DefaultPathBinderBuilder();
        Matcher matchResult = PLACEHOLDER.matcher(path);
        int lastIndex = 0;
        if (matchResult.find()) {
            do {
                int thisIndex;
                if ((thisIndex = matchResult.start()) != lastIndex) {
                    pathBinderBuilder.literal(path.substring(lastIndex, thisIndex));
                }
                lastIndex = matchResult.end();
                String component = matchResult.group(0);
                boolean found = false;
                for (PathTokenType type : PathTokenType.values()) {
                    if (!type.match(component, pathBinderBuilder)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException(String.format("Cannot match path %s (%s)", path, component));
            } while (matchResult.find());
            if (lastIndex < path.length()) {
                pathBinderBuilder.literal(path.substring(lastIndex));
            }
        } else {
            pathBinderBuilder.literal(path);
        }
        return pathBinderBuilder.build(exact);
    }
}

