/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.parse;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import ratpack.core.parse.ParseException;
import ratpack.core.parse.Parser;

public class NoSuchParserException
extends ParseException {
    private static final long serialVersionUID = 0L;
    private static final String NEWLINE = System.getProperty("line.separator");
    private final TypeToken<?> type;
    private final Object opts;
    private final String contentType;

    public NoSuchParserException(TypeToken<?> type, Object opts, String contentType) {
        super(NoSuchParserException.getMessage(type, opts, contentType, Collections.emptyList()));
        this.type = type;
        this.opts = opts;
        this.contentType = contentType;
    }

    public NoSuchParserException(TypeToken<?> type, Object opts, String contentType, Iterable<Parser<?>> parsers) {
        super(NoSuchParserException.getMessage(type, opts, contentType, parsers));
        this.type = type;
        this.opts = opts;
        this.contentType = contentType;
    }

    private static String getMessage(TypeToken<?> type, Object opts, String contentType, Iterable<Parser<?>> parsers) {
        String message = "Could not find parser able to produce object of type '" + type + "' from request of content type '" + contentType + "'" + (opts == null ? "" : " and parse options '" + opts + "'");
        String used = Joiner.on((String)NEWLINE).join(Iterables.transform(parsers, p -> "  - ".concat(p.toString())));
        if (!used.isEmpty()) {
            message = message + ". The following parsers were tried:" + NEWLINE + used;
        }
        return message;
    }

    public TypeToken<?> getType() {
        return this.type;
    }

    public Object getOpts() {
        return this.opts;
    }

    public String getContentType() {
        return this.contentType;
    }
}

