/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.jackson.internal;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import ratpack.core.handling.Context;
import ratpack.core.http.TypedData;
import ratpack.core.jackson.JsonParseOpts;
import ratpack.core.jackson.internal.DefaultJsonParseOpts;
import ratpack.core.parse.Parse;
import ratpack.core.parse.Parser;
import ratpack.core.parse.ParserSupport;
import ratpack.func.Types;

public class JsonParser
extends ParserSupport<JsonParseOpts> {
    private static final TypeToken<JsonNode> JSON_NODE_TYPE = Types.token(JsonNode.class);
    public static final TypeToken<Parser<JsonParseOpts>> TYPE = Types.intern((TypeToken)new TypeToken<Parser<JsonParseOpts>>(){});
    public static final Parser<JsonParseOpts> INSTANCE = new JsonParser();

    private JsonParser() {
    }

    @Override
    public <T> T parse(Context context, TypedData body, Parse<T, JsonParseOpts> parse) throws IOException {
        if (!body.getContentType().isJson()) {
            return null;
        }
        JsonParseOpts opts = parse.getOpts().orElse(DefaultJsonParseOpts.INSTANCE);
        TypeToken<T> type = parse.getType();
        ObjectMapper objectMapper = opts.getObjectMapper().orElseGet(() -> (ObjectMapper)context.get(ObjectMapper.class));
        InputStream inputStream = body.getInputStream();
        if (type.equals(JSON_NODE_TYPE)) {
            return (T)Types.cast((Object)objectMapper.readTree(inputStream));
        }
        return (T)objectMapper.readValue(inputStream, this.toJavaType(type, objectMapper));
    }

    private <T> JavaType toJavaType(TypeToken<T> type, ObjectMapper objectMapper) {
        return objectMapper.getTypeFactory().constructType(type.getType());
    }

    public String toString() {
        return this.getClass().getName() + " (parses 'application/json' and types ending in '+json')";
    }
}

