/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.internal;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ratpack.core.http.HttpUrlBuilder;
import ratpack.exec.util.internal.InternalRatpackError;
import ratpack.func.MultiValueMap;

public class DefaultHttpUrlBuilder
implements HttpUrlBuilder {
    private static final CharMatcher HOST_NAME_ILLEGAL_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)".-")).negate().precomputed();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    public static final Escaper PATH_SEGMENT_ESCAPER = UrlEscapers.urlPathSegmentEscaper();
    private String protocol = "http";
    private String host = "localhost";
    private int port = -1;
    private final List<String> pathSegments = new ArrayList<String>();
    private final Multimap<String, Object> params = MultimapBuilder.linkedHashKeys().linkedListValues().build();
    private boolean hasTrailingSlash;
    private String fragment;

    public DefaultHttpUrlBuilder() {
    }

    public DefaultHttpUrlBuilder(URI uri) {
        this.protocol = uri.getScheme();
        if (this.protocol == null) {
            this.protocol = "http";
        }
        this.protocol = this.protocol.toLowerCase();
        if (!this.protocol.equals("http") && !this.protocol.equals("https")) {
            throw new IllegalArgumentException("uri " + uri + " must be a http or https uri");
        }
        this.host(uri.getHost());
        this.port(uri.getPort());
        String rawPath = uri.getRawPath();
        if (rawPath != null && !rawPath.isEmpty() && !rawPath.equals("/")) {
            String[] parts;
            for (String part : parts = rawPath.substring(1).split("/")) {
                try {
                    String s = part.replaceAll("\\+", "%2B");
                    this.segment(URLDecoder.decode(s, "UTF8"), new Object[0]);
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalRatpackError("UTF8 is not available", (Throwable)e);
                }
            }
            this.hasTrailingSlash = rawPath.substring(rawPath.length() - 1, rawPath.length()).equals("/");
        }
        if (uri.getRawQuery() != null) {
            new QueryStringDecoder(uri).parameters().forEach((arg_0, arg_1) -> this.params.putAll(arg_0, arg_1));
        }
        this.fragment = uri.getFragment();
    }

    @Override
    public HttpUrlBuilder secure() {
        this.protocol = "https";
        return this;
    }

    @Override
    public HttpUrlBuilder host(String host) {
        int indexIn = HOST_NAME_ILLEGAL_CHARS.indexIn((CharSequence)host);
        if (indexIn >= 0) {
            throw new IllegalArgumentException("character '" + host.charAt(indexIn) + "' of host name '" + host + "' is invalid (only [a-zA-Z0-9.-] are allowed in host names)");
        }
        this.host = host;
        return this;
    }

    @Override
    public HttpUrlBuilder port(int port) {
        if (port == 0 || port < -1) {
            throw new IllegalArgumentException("port must be greater than 0 or exactly -1, is " + port);
        }
        this.port = port;
        return this;
    }

    @Override
    public HttpUrlBuilder encodedPath(String path) {
        Objects.requireNonNull(path, "path must not be null");
        this.hasTrailingSlash = path.endsWith("/");
        Arrays.stream(path.split("/")).filter(s -> !s.isEmpty()).forEach(this.pathSegments::add);
        return this;
    }

    @Override
    public HttpUrlBuilder path(String path) {
        Objects.requireNonNull(path, "path must not be null");
        this.hasTrailingSlash = path.endsWith("/");
        Arrays.stream(path.split("/")).filter(s -> !s.isEmpty()).forEach(x$0 -> this.segment((String)x$0, new Object[0]));
        return this;
    }

    @Override
    public HttpUrlBuilder segment(String pathSegment, Object ... args) {
        Objects.requireNonNull(pathSegment, "pathSegment must not be null");
        if (args.length == 0) {
            this.pathSegments.add(PATH_SEGMENT_ESCAPER.escape(pathSegment));
        } else {
            this.pathSegments.add(PATH_SEGMENT_ESCAPER.escape(String.format(pathSegment, args)));
        }
        return this;
    }

    @Override
    public HttpUrlBuilder params(String ... params) {
        int i = 0;
        while (i < params.length) {
            String key = params[i];
            String value = "";
            if (++i < params.length) {
                value = params[i++];
            }
            this.params.put((Object)key, (Object)value);
        }
        return this;
    }

    @Override
    public HttpUrlBuilder params(Map<String, ?> params) {
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            this.params.put((Object)entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public HttpUrlBuilder params(Multimap<String, ?> params) {
        this.params.putAll(params);
        return this;
    }

    @Override
    public HttpUrlBuilder params(MultiValueMap<String, ?> params) {
        this.params.putAll((Multimap)params.asMultimap());
        return this;
    }

    @Override
    public HttpUrlBuilder fragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    @Override
    public URI build() {
        String string = this.toString();
        try {
            return new URI(string);
        }
        catch (URISyntaxException e) {
            throw new InternalRatpackError("HttpUriBuilder produced invalid URI: " + this.toString(), (Throwable)e);
        }
    }

    private void appendPathString(StringBuilder stringBuilder) {
        if (!this.pathSegments.isEmpty()) {
            stringBuilder.append("/");
            PATH_JOINER.appendTo(stringBuilder, this.pathSegments);
        }
    }

    private void appendQueryString(StringBuilder stringBuilder) {
        if (!this.params.isEmpty()) {
            stringBuilder.append("?");
            Iterator parts = this.params.entries().iterator();
            if (parts.hasNext()) {
                Map.Entry entry = (Map.Entry)parts.next();
                stringBuilder.append(UrlEscapers.urlFormParameterEscaper().escape((String)entry.getKey()));
                String value = entry.getValue().toString();
                if (value != null && value.length() > 0) {
                    stringBuilder.append("=");
                    stringBuilder.append(UrlEscapers.urlFormParameterEscaper().escape(value));
                }
                while (parts.hasNext()) {
                    stringBuilder.append("&");
                    Map.Entry e = (Map.Entry)parts.next();
                    stringBuilder.append(UrlEscapers.urlFormParameterEscaper().escape((String)e.getKey()));
                    String v = e.getValue().toString();
                    if (v == null || v.length() <= 0) continue;
                    stringBuilder.append("=");
                    stringBuilder.append(UrlEscapers.urlFormParameterEscaper().escape(v));
                }
            }
        }
    }

    public String toString() {
        StringBuilder uri = new StringBuilder(this.protocol).append("://").append(this.host);
        if (this.port > -1) {
            uri.append(":").append(this.port);
        }
        this.appendPathString(uri);
        if (this.hasTrailingSlash) {
            uri.append("/");
        }
        this.appendQueryString(uri);
        if (this.fragment != null) {
            uri.append("#").append(this.fragment);
        }
        return uri.toString();
    }
}

