/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.client.internal;

import java.util.Map;
import ratpack.core.http.client.internal.HostStats;

public class HttpClientStats {
    private final Map<String, HostStats> statsPerHost;

    public HttpClientStats(Map<String, HostStats> statsPerHost) {
        this.statsPerHost = statsPerHost;
    }

    public Map<String, HostStats> getStatsPerHost() {
        return this.statsPerHost;
    }

    public long getTotalConnectionCount() {
        return this.getTotalActiveConnectionCount() + this.getTotalIdleConnectionCount();
    }

    public long getTotalActiveConnectionCount() {
        return this.statsPerHost.values().stream().mapToLong(HostStats::getActiveConnectionCount).sum();
    }

    public long getTotalIdleConnectionCount() {
        return this.statsPerHost.values().stream().mapToLong(HostStats::getIdleConnectionCount).sum();
    }

    public String toString() {
        return "There are " + this.getTotalConnectionCount() + " total connections, " + this.getTotalActiveConnectionCount() + " are active and " + this.getTotalIdleConnectionCount() + " are idle.";
    }
}

