/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.client.internal;

import io.netty.buffer.ByteBuf;
import ratpack.core.http.Headers;
import ratpack.core.http.Response;
import ratpack.core.http.Status;
import ratpack.core.http.TypedData;
import ratpack.core.http.client.ReceivedResponse;
import ratpack.core.http.internal.ByteBufBackedTypedData;

public class DefaultReceivedResponse
implements ReceivedResponse {
    private final Status status;
    private final Headers headers;
    private final ByteBufBackedTypedData typedData;

    public DefaultReceivedResponse(Status status, Headers headers, ByteBufBackedTypedData typedData) {
        this.status = status;
        this.headers = headers;
        this.typedData = typedData;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public int getStatusCode() {
        return this.status.getCode();
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public TypedData getBody() {
        return this.typedData;
    }

    @Override
    public void forwardTo(Response response) {
        response.getHeaders().copy(this.headers);
        response.status(this.status);
        ByteBuf buffer = this.typedData.getBuffer();
        if (buffer.readableBytes() > 0) {
            response.send(buffer.retain());
        } else {
            buffer.release();
            response.send();
        }
    }
}

