/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.client;

import io.netty.buffer.ByteBufAllocator;
import java.net.URI;
import java.time.Duration;
import ratpack.core.http.client.HttpClientSpec;
import ratpack.core.http.client.Proxy;
import ratpack.core.http.client.ReceivedResponse;
import ratpack.core.http.client.RequestSpec;
import ratpack.core.http.client.StreamedResponse;
import ratpack.core.http.client.internal.HttpClientBuilder;
import ratpack.exec.Promise;
import ratpack.func.Action;

public interface HttpClient
extends AutoCloseable {
    public static HttpClient of(Action<? super HttpClientSpec> action) throws Exception {
        HttpClientBuilder builder = new HttpClientBuilder();
        action.execute((Object)builder);
        return builder.build();
    }

    public Promise<ReceivedResponse> get(URI var1, Action<? super RequestSpec> var2);

    default public Promise<ReceivedResponse> get(URI uri) {
        return this.get(uri, (Action<? super RequestSpec>)Action.noop());
    }

    public ByteBufAllocator getByteBufAllocator();

    public int getPoolSize();

    public int getPoolQueueSize();

    public Duration getIdleTimeout();

    public Duration getReadTimeout();

    public Duration getConnectTimeout();

    public int getMaxContentLength();

    public int getMaxResponseChunkSize();

    public Proxy getProxy();

    @Override
    public void close();

    public HttpClient copyWith(Action<? super HttpClientSpec> var1) throws Exception;

    public Promise<ReceivedResponse> post(URI var1, Action<? super RequestSpec> var2);

    public Promise<ReceivedResponse> request(URI var1, Action<? super RequestSpec> var2);

    public Promise<StreamedResponse> requestStream(URI var1, Action<? super RequestSpec> var2);
}

