/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.handling.internal;

import com.google.common.net.HostAndPort;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.slf4j.Logger;
import ratpack.core.handling.RequestId;
import ratpack.core.handling.RequestLogger;
import ratpack.core.handling.RequestOutcome;
import ratpack.core.handling.UserId;
import ratpack.core.http.HttpMethod;
import ratpack.core.http.Request;
import ratpack.core.http.SentResponse;
import ratpack.core.http.Status;
import ratpack.core.http.internal.HttpHeaderConstants;
import ratpack.func.Types;

public class NcsaRequestLogger
implements RequestLogger {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z").withZone(ZoneId.systemDefault());
    private final Logger logger;

    public NcsaRequestLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void log(RequestOutcome outcome) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        Request request = outcome.getRequest();
        SentResponse response = outcome.getResponse();
        String responseSize = "-";
        String contentLength = response.getHeaders().get(HttpHeaderConstants.CONTENT_LENGTH);
        if (contentLength != null) {
            responseSize = contentLength;
        }
        StringBuilder logLine = new StringBuilder().append(this.ncsaLogFormat(request.getRemoteAddress(), "-", request.maybeGet(UserId.class).map(Types::cast), request.getTimestamp(), request.getMethod(), request.getRawUri(), request.getProtocol(), outcome.getResponse().getStatus(), responseSize));
        request.maybeGet(RequestId.class).ifPresent(id1 -> {
            logLine.append(" id=");
            logLine.append((CharSequence)id1);
        });
        this.logger.info(logLine.toString());
    }

    String ncsaLogFormat(HostAndPort client, String rfc1413Ident, Optional<CharSequence> userId, Instant timestamp, HttpMethod method, String uri, String httpProtocol, Status status, String responseSize) {
        return String.format("%s %s %s [%s] \"%s %s %s\" %d %s", client.getHost(), rfc1413Ident, userId.orElse("-"), FORMATTER.format(timestamp), method.getName(), uri, httpProtocol, status.getCode(), responseSize);
    }
}

