/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.handling;

import java.util.List;
import ratpack.core.file.FileHandlerSpec;
import ratpack.core.file.internal.DefaultFileHandlerSpec;
import ratpack.core.file.internal.FileSystemBindingHandler;
import ratpack.core.handling.ByContentSpec;
import ratpack.core.handling.ByMethodSpec;
import ratpack.core.handling.Chain;
import ratpack.core.handling.Context;
import ratpack.core.handling.Handler;
import ratpack.core.handling.internal.AcceptsHandler;
import ratpack.core.handling.internal.ChainActionTransformer;
import ratpack.core.handling.internal.ChainBuilders;
import ratpack.core.handling.internal.ChainHandler;
import ratpack.core.handling.internal.ClientErrorForwardingHandler;
import ratpack.core.handling.internal.ContentNegotiationHandler;
import ratpack.core.handling.internal.ContentTypeHandler;
import ratpack.core.handling.internal.MethodHandler;
import ratpack.core.handling.internal.MultiMethodHandler;
import ratpack.core.handling.internal.NextHandler;
import ratpack.core.handling.internal.OnlyIfHandler;
import ratpack.core.handling.internal.RedirectionHandler;
import ratpack.core.handling.internal.RegistryInsertHandler;
import ratpack.core.handling.internal.RegistryNextHandler;
import ratpack.core.handling.internal.WhenHandler;
import ratpack.core.path.PathBinder;
import ratpack.core.path.internal.PathHandler;
import ratpack.core.server.ServerConfig;
import ratpack.exec.registry.Registry;
import ratpack.func.Action;
import ratpack.func.Block;
import ratpack.func.Nullable;
import ratpack.func.Predicate;

public abstract class Handlers {
    private Handlers() {
    }

    public static Handler accepts(String ... contentTypes) {
        return new AcceptsHandler(contentTypes);
    }

    public static Handler files(ServerConfig serverConfig, Action<? super FileHandlerSpec> config) throws Exception {
        return DefaultFileHandlerSpec.build(serverConfig, config);
    }

    public static Handler chain(ServerConfig serverConfig, Action<? super Chain> action) throws Exception {
        return Handlers.chain(serverConfig, null, action);
    }

    public static Handler chain(@Nullable ServerConfig serverConfig, @Nullable Registry registry, Action<? super Chain> action) throws Exception {
        return ChainBuilders.build(new ChainActionTransformer(serverConfig, registry), action);
    }

    public static Handler chain(Registry registry, Action<? super Chain> action) throws Exception {
        return Handlers.chain((ServerConfig)registry.get(ServerConfig.class), registry, action);
    }

    public static Handler chain(List<? extends Handler> handlers) {
        if (handlers.size() == 0) {
            return Context::next;
        }
        if (handlers.size() == 1) {
            return handlers.get(0);
        }
        return new ChainHandler(handlers);
    }

    public static Handler chain(Handler ... handlers) {
        if (handlers.length == 0) {
            return Handlers.next();
        }
        if (handlers.length == 1) {
            return handlers[0];
        }
        return new ChainHandler(handlers);
    }

    public static Handler clientError(int statusCode) {
        return new ClientErrorForwardingHandler(statusCode);
    }

    public static Handler contentTypes(String ... contentTypes) {
        return new ContentTypeHandler(contentTypes);
    }

    public static Handler delete() {
        return MethodHandler.DELETE;
    }

    public static Handler fileSystem(ServerConfig serverConfig, String path, Handler handler) {
        return new FileSystemBindingHandler(serverConfig, path, handler);
    }

    public static Handler get() {
        return MethodHandler.GET;
    }

    public static Handler next() {
        return NextHandler.INSTANCE;
    }

    public static Handler notFound() {
        return ClientErrorForwardingHandler.NOT_FOUND;
    }

    public static Handler patch() {
        return MethodHandler.PATCH;
    }

    public static Handler options() {
        return MethodHandler.OPTIONS;
    }

    public static Handler path(String path, Handler handler) {
        return Handlers.path(PathBinder.parse(path, true), handler);
    }

    public static Handler path(PathBinder pathBinder, Handler handler) {
        return new PathHandler(pathBinder, handler);
    }

    public static Handler post() {
        return MethodHandler.POST;
    }

    public static Handler prefix(String prefix, Handler handler) {
        return Handlers.path(PathBinder.parse(prefix, false), handler);
    }

    public static Handler put() {
        return MethodHandler.PUT;
    }

    public static Handler register(Registry registry, Handler handler) {
        return new RegistryInsertHandler(registry, handler);
    }

    public static Handler register(Registry registry) {
        return new RegistryNextHandler(registry);
    }

    public static Handler redirect(int code, String location) {
        return new RedirectionHandler(location, code);
    }

    public static Handler when(Predicate<? super Context> test, Handler handler) {
        return new WhenHandler(test, handler);
    }

    public static Handler whenOrElse(Predicate<? super Context> test, Handler ifHandler, Handler elseHandler) {
        return new WhenHandler(test, ifHandler, elseHandler);
    }

    public static Handler onlyIf(Predicate<? super Context> test, Handler handler) {
        return new OnlyIfHandler(test, handler);
    }

    public static Handler of(Block block) {
        return ctx -> block.execute();
    }

    public static Handler byContent(Registry registry, Action<? super ByContentSpec> action) throws Exception {
        return new ContentNegotiationHandler(registry, action);
    }

    public static Handler byMethod(Registry registry, Action<? super ByMethodSpec> action) throws Exception {
        return new MultiMethodHandler(registry, action);
    }
}

