/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.form.internal;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import ratpack.core.form.Form;
import ratpack.core.form.UploadedFile;
import ratpack.core.form.internal.DefaultForm;
import ratpack.core.form.internal.DefaultUploadedFile;
import ratpack.core.handling.Context;
import ratpack.core.handling.RequestOutcome;
import ratpack.core.http.MediaType;
import ratpack.core.http.Request;
import ratpack.core.http.TypedData;
import ratpack.core.http.internal.ByteBufBackedTypedData;
import ratpack.core.http.internal.DefaultMediaType;
import ratpack.func.Action;
import ratpack.func.Exceptions;
import ratpack.func.MultiValueMap;
import ratpack.func.internal.ImmutableDelegatingMultiValueMap;

public abstract class FormDecoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Form parseForm(Context context, TypedData body, MultiValueMap<String, String> base) throws RuntimeException {
        Request request = context.getRequest();
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod().getName());
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, method, request.getUri());
        nettyRequest.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)body.getContentType().toString());
        LinkedHashMap<String, List> attributes = new LinkedHashMap<String, List>(base.getAll());
        LinkedHashMap<String, List> files = new LinkedHashMap<String, List>();
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpRequest)nettyRequest);
        try {
            DefaultHttpContent content = new DefaultHttpContent(body.getBuffer());
            decoder.offer((HttpContent)content);
            decoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
            InterfaceHttpData data = decoder.next();
            while (data != null) {
                List values;
                if (data.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.Attribute)) {
                    values = attributes.computeIfAbsent(data.getName(), k -> new ArrayList(1));
                    try {
                        values.add(((Attribute)data).getValue());
                    }
                    catch (IOException e) {
                        throw Exceptions.uncheck((Throwable)e);
                    }
                }
                if (data.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.FileUpload)) {
                    values = files.computeIfAbsent(data.getName(), k -> new ArrayList(1));
                    try {
                        Charset charset;
                        FileUpload nettyFileUpload = (FileUpload)data;
                        ByteBuf byteBuf = nettyFileUpload.getByteBuf();
                        byteBuf.retain();
                        context.onClose((Action<? super RequestOutcome>)((Action)ro -> byteBuf.release()));
                        String rawContentType = nettyFileUpload.getContentType();
                        MediaType contentType = rawContentType == null ? null : ((charset = nettyFileUpload.getCharset()) == null ? DefaultMediaType.get(rawContentType) : DefaultMediaType.get(rawContentType + ";charset=" + charset));
                        DefaultUploadedFile fileUpload = new DefaultUploadedFile(new ByteBufBackedTypedData(byteBuf, contentType), nettyFileUpload.getFilename());
                        values.add(fileUpload);
                    }
                    catch (IOException e) {
                        throw Exceptions.uncheck((Throwable)e);
                    }
                }
                data = decoder.next();
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
        }
        finally {
            decoder.destroy();
        }
        return new DefaultForm((MultiValueMap<String, String>)new ImmutableDelegatingMultiValueMap(attributes), (MultiValueMap<String, UploadedFile>)new ImmutableDelegatingMultiValueMap(files));
    }
}

