/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.file.internal;

import io.netty.buffer.ByteBuf;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.exec.Downstream;
import ratpack.exec.Promise;

public class FileWritingSubscriber
implements Subscriber<ByteBuf> {
    private final AsynchronousFileChannel out;
    private final Downstream<? super Long> downstream;
    private final long startAt;
    private long position;
    private Subscription s;
    private boolean cancelled;

    public FileWritingSubscriber(AsynchronousFileChannel out, long position, Downstream<? super Long> downstream) {
        this.position = position;
        this.startAt = position;
        this.downstream = downstream;
        this.out = out;
        if (position < 0L) {
            throw new IllegalArgumentException("position must be >= 0");
        }
    }

    public void onSubscribe(Subscription s) {
        this.s = s;
        s.request(1L);
    }

    public void onNext(final ByteBuf byteBuf) {
        int toWrite = byteBuf.readableBytes();
        if (this.cancelled || toWrite < 1) {
            byteBuf.release();
            if (!this.cancelled) {
                this.s.request(1L);
            }
            return;
        }
        Promise.async(down -> this.out.write(byteBuf.nioBuffer(), this.position, null, new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer result, Void attachment) {
                byteBuf.release();
                down.success((Object)result);
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                byteBuf.release();
                down.error(exc);
            }
        })).onError(e -> {
            this.cancelled = true;
            this.s.cancel();
            this.downstream.error(e);
        }).then(i -> {
            this.position += (long)i.intValue();
            this.s.request(1L);
        });
    }

    public void onError(Throwable t) {
        if (!this.cancelled) {
            this.downstream.error(t);
        }
    }

    public void onComplete() {
        this.downstream.success((Object)(this.position - this.startAt));
    }
}

