/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.file.internal;

import com.google.common.collect.ImmutableList;
import ratpack.core.file.BaseDirRequiredException;
import ratpack.core.file.FileHandlerSpec;
import ratpack.core.file.internal.FileHandler;
import ratpack.core.handling.Handler;
import ratpack.core.handling.Handlers;
import ratpack.core.server.ServerConfig;
import ratpack.func.Action;

public class DefaultFileHandlerSpec
implements FileHandlerSpec {
    private String path;
    private String dir;
    private ImmutableList<String> indexFiles = ImmutableList.of();

    @Override
    public FileHandlerSpec path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public FileHandlerSpec dir(String dir) {
        this.dir = dir;
        return this;
    }

    @Override
    public FileHandlerSpec indexFiles(String ... indexFiles) {
        this.indexFiles = ImmutableList.copyOf((Object[])indexFiles);
        return this;
    }

    public static Handler build(ServerConfig serverConfig, Action<? super FileHandlerSpec> config) throws Exception {
        if (!serverConfig.isHasBaseDir()) {
            throw new BaseDirRequiredException("no base dir set for application");
        }
        DefaultFileHandlerSpec spec = new DefaultFileHandlerSpec();
        config.execute((Object)spec);
        Handler handler = new FileHandler(spec.indexFiles, !serverConfig.isDevelopment());
        if (spec.dir != null) {
            handler = Handlers.fileSystem(serverConfig, spec.dir, handler);
        }
        if (spec.path != null) {
            handler = Handlers.prefix(spec.path, handler);
        }
        return handler;
    }
}

