/*
 * Decompiled with CFR 0.152.
 */
package ratpack.websocket.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.handling.direct.DirectChannelAccess;
import ratpack.http.Request;
import ratpack.server.PublicAddress;
import ratpack.util.ExceptionUtils;
import ratpack.websocket.WebSocketHandler;
import ratpack.websocket.internal.DefaultWebSocket;
import ratpack.websocket.internal.DefaultWebSocketClose;
import ratpack.websocket.internal.DefaultWebSocketMessage;

public class WebSocketConnector {
    public static <T> void connect(Context context, String path, int maxLength, WebSocketHandler<T> handler) {
        URI wsPath;
        PublicAddress publicAddress = context.get(PublicAddress.class);
        URI address = publicAddress.getAddress(context);
        URI httpPath = address.resolve(path);
        try {
            wsPath = new URI("ws", httpPath.getUserInfo(), httpPath.getHost(), httpPath.getPort(), httpPath.getPath(), httpPath.getQuery(), httpPath.getFragment());
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.uncheck(e);
        }
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(wsPath.toString(), null, false, maxLength);
        Request request = context.getRequest();
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod().getName());
        DefaultFullHttpRequest nettyRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, request.getUri());
        nettyRequest.headers().add("Sec-WebSocket-Version", (Object)request.getHeaders().get("Sec-WebSocket-Version"));
        nettyRequest.headers().add("Sec-WebSocket-Key", (Object)request.getHeaders().get("Sec-WebSocket-Key"));
        WebSocketServerHandshaker handshaker = factory.newHandshaker((HttpRequest)nettyRequest);
        DirectChannelAccess directChannelAccess = context.getDirectChannelAccess();
        Channel channel = directChannelAccess.getChannel();
        handshaker.handshake(channel, (FullHttpRequest)nettyRequest).addListener(new HandshakeFutureListener<T>(context, handshaker, handler));
    }

    private static class HandshakeFutureListener<T>
    implements ChannelFutureListener {
        private final Context context;
        private final WebSocketServerHandshaker handshaker;
        private final WebSocketHandler<T> handler;
        private volatile T openResult;
        private final CountDownLatch openLatch = new CountDownLatch(1);

        public HandshakeFutureListener(Context context, WebSocketServerHandshaker handshaker, WebSocketHandler<T> handler) {
            this.context = context;
            this.handshaker = handshaker;
            this.handler = handler;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                final AtomicBoolean open = new AtomicBoolean(true);
                final DefaultWebSocket webSocket = new DefaultWebSocket(this.context.getDirectChannelAccess().getChannel(), open, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HandshakeFutureListener.this.handler.onClose(new DefaultWebSocketClose<Object>(false, HandshakeFutureListener.this.openResult));
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.uncheck(e);
                        }
                    }
                });
                this.context.getDirectChannelAccess().takeOwnership(new Action<Object>(){

                    @Override
                    public void execute(Object msg) throws Exception {
                        HandshakeFutureListener.this.openLatch.await();
                        Channel channel = HandshakeFutureListener.this.context.getDirectChannelAccess().getChannel();
                        if (channel.isOpen() && msg instanceof WebSocketFrame) {
                            WebSocketFrame frame = (WebSocketFrame)msg;
                            if (frame instanceof CloseWebSocketFrame) {
                                open.set(false);
                                HandshakeFutureListener.this.handshaker.close(channel, (CloseWebSocketFrame)frame.retain()).addListener((GenericFutureListener)new ChannelFutureListener(){

                                    public void operationComplete(ChannelFuture future) throws Exception {
                                        HandshakeFutureListener.this.handler.onClose(new DefaultWebSocketClose<Object>(true, HandshakeFutureListener.this.openResult));
                                    }
                                });
                                return;
                            }
                            if (frame instanceof PingWebSocketFrame) {
                                channel.write((Object)new PongWebSocketFrame(frame.content().retain()));
                                return;
                            }
                            if (frame instanceof TextWebSocketFrame) {
                                TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)frame;
                                HandshakeFutureListener.this.handler.onMessage(new DefaultWebSocketMessage<Object>(webSocket, textWebSocketFrame.text(), HandshakeFutureListener.this.openResult));
                            }
                        }
                    }
                });
                try {
                    this.openResult = this.handler.onOpen(webSocket);
                }
                catch (Exception e) {
                    this.handshaker.close(this.context.getDirectChannelAccess().getChannel(), new CloseWebSocketFrame(1011, e.getMessage()));
                }
                this.openLatch.countDown();
            } else {
                this.context.error(ExceptionUtils.toException(future.cause()));
            }
        }
    }
}

