/*
 * Decompiled with CFR 0.152.
 */
package ratpack.render.internal;

import java.util.List;
import ratpack.handling.Context;
import ratpack.render.NoSuchRendererException;
import ratpack.render.Renderer;
import ratpack.render.RendererException;
import ratpack.render.internal.RenderController;

public class DefaultRenderController
implements RenderController {
    @Override
    public void render(Object object, Context context) {
        if (object == null) {
            context.clientError(404);
            return;
        }
        List<Renderer> all = context.getAll(Renderer.class);
        for (Renderer renderer : all) {
            try {
                if (!this.maybeRender(object, renderer, context)) continue;
                return;
            }
            catch (Exception e) {
                context.error(new RendererException(renderer, object, e));
            }
        }
        context.error(new NoSuchRendererException((Object)("No renderer for object '" + object + "' of type '" + object.getClass() + "'")));
    }

    private <T> boolean maybeRender(Object object, Renderer<T> renderer, Context context) throws Exception {
        if (renderer.getType().isInstance(object)) {
            Object cast = object;
            renderer.render(context, cast);
            return true;
        }
        return false;
    }
}

