/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling;

import com.google.common.collect.ImmutableList;
import java.util.List;
import ratpack.file.internal.AssetHandler;
import ratpack.file.internal.FileSystemBindingHandler;
import ratpack.func.Action;
import ratpack.handling.Chain;
import ratpack.handling.Handler;
import ratpack.handling.internal.ChainActionTransformer;
import ratpack.handling.internal.ChainBuilders;
import ratpack.handling.internal.ChainHandler;
import ratpack.handling.internal.NextHandler;
import ratpack.handling.internal.RegisteringHandler;
import ratpack.http.internal.AcceptsHandler;
import ratpack.http.internal.ContentTypeHandler;
import ratpack.http.internal.HeaderHandler;
import ratpack.http.internal.MethodHandler;
import ratpack.launch.LaunchConfig;
import ratpack.path.PathBinder;
import ratpack.path.internal.PathHandler;
import ratpack.path.internal.TokenPathBinder;
import ratpack.registry.Registry;

public abstract class Handlers {
    private Handlers() {
    }

    public static <T> Handler register(T object, Handler handler) {
        return new RegisteringHandler(object, handler);
    }

    public static <T> Handler register(Class<? super T> type, T object, Handler handler) {
        return new RegisteringHandler(type, object, handler);
    }

    public static Handler chain(LaunchConfig launchConfig, Action<? super Chain> action) throws Exception {
        return Handlers.chain(launchConfig, null, action);
    }

    public static Handler chain(LaunchConfig launchConfig, Registry registry, Action<? super Chain> action) throws Exception {
        return ChainBuilders.build(launchConfig != null && launchConfig.isReloadable(), new ChainActionTransformer(launchConfig, registry), action);
    }

    public static Handler chain(List<? extends Handler> handlers) {
        if (handlers.size() == 0) {
            return Handlers.next();
        }
        if (handlers.size() == 1) {
            return handlers.get(0);
        }
        return new ChainHandler(handlers);
    }

    public static Handler chain(Handler ... handlers) {
        if (handlers.length == 0) {
            return Handlers.next();
        }
        if (handlers.length == 1) {
            return handlers[0];
        }
        return new ChainHandler(handlers);
    }

    public static Handler fileSystem(String path, Handler handler) {
        return new FileSystemBindingHandler(path, handler);
    }

    public static Handler assets(String path, List<String> indexFiles) {
        AssetHandler handler = new AssetHandler((ImmutableList<String>)ImmutableList.copyOf(indexFiles));
        return Handlers.fileSystem(path, handler);
    }

    public static Handler next() {
        return NextHandler.INSTANCE;
    }

    public static Handler get() {
        return MethodHandler.GET;
    }

    public static Handler post() {
        return MethodHandler.POST;
    }

    public static Handler contentTypes(String ... contentTypes) {
        return new ContentTypeHandler(contentTypes);
    }

    public static Handler accepts(String ... contentTypes) {
        return new AcceptsHandler(contentTypes);
    }

    public static Handler put() {
        return MethodHandler.PUT;
    }

    public static Handler patch() {
        return MethodHandler.PATCH;
    }

    public static Handler delete() {
        return MethodHandler.DELETE;
    }

    public static Handler prefix(String prefix, Handler handler) {
        return Handlers.path(new TokenPathBinder(prefix, false), handler);
    }

    public static Handler path(String path, Handler handler) {
        return Handlers.path(new TokenPathBinder(path, true), handler);
    }

    public static Handler path(PathBinder pathBinder, Handler handler) {
        return new PathHandler(pathBinder, handler);
    }

    public static Handler header(String headerName, String headerValue, Handler handler) {
        return new HeaderHandler(headerName, headerValue, handler);
    }
}

