/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.Blob;
import io.r2dbc.spi.test.Assert;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MockBlob
implements Blob {
    private final Flux<ByteBuffer> stream;
    private boolean discardCalled = false;

    private MockBlob(Flux<ByteBuffer> stream) {
        this.stream = Assert.requireNonNull(stream, "stream must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockBlob empty() {
        return MockBlob.builder().build();
    }

    public Publisher<Void> discard() {
        this.discardCalled = true;
        return Mono.empty();
    }

    public boolean isDiscardCalled() {
        return this.discardCalled;
    }

    public Publisher<ByteBuffer> stream() {
        return this.stream;
    }

    public String toString() {
        return "MockBlob{stream=" + this.stream + ", discardCalled=" + this.discardCalled + '}';
    }

    public static final class Builder {
        private final List<ByteBuffer> items = new ArrayList<ByteBuffer>();

        private Builder() {
        }

        public MockBlob build() {
            return new MockBlob(Flux.fromIterable(this.items));
        }

        public Builder item(ByteBuffer ... items) {
            Assert.requireNonNull(items, "items must not be null");
            Stream.of(items).peek(item -> Assert.requireNonNull(item, "item must not be null")).forEach(this.items::add);
            return this;
        }

        public String toString() {
            return "Builder{items=" + this.items + '}';
        }
    }
}

