/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.observation;

import io.r2dbc.proxy.core.Bindings;
import io.r2dbc.proxy.observation.QueryParametersTagProvider;
import io.r2dbc.proxy.support.QueryExecutionInfoFormatter;
import java.util.List;

public class DefaultQueryParametersTagProvider
implements QueryParametersTagProvider {
    private final QueryExecutionInfoFormatter formatter = new QueryExecutionInfoFormatter();

    @Override
    public String getTagValue(List<Bindings> bindingsList) {
        if (bindingsList.isEmpty()) {
            return "()";
        }
        StringBuilder sb = new StringBuilder();
        for (Bindings bindings : bindingsList) {
            sb.append("(");
            if (!bindings.getIndexBindings().isEmpty()) {
                this.formatter.onIndexBindings.accept(bindings.getIndexBindings(), sb);
            } else if (!bindings.getNamedBindings().isEmpty()) {
                this.formatter.onNamedBindings.accept(bindings.getNamedBindings(), sb);
            }
            sb.append("),");
        }
        this.chompIfEndWith(sb, ',');
        return sb.toString();
    }

    protected void chompIfEndWith(StringBuilder sb, char c) {
        int lastCharIndex = sb.length() - 1;
        if (lastCharIndex >= 0 && sb.charAt(lastCharIndex) == c) {
            sb.deleteCharAt(lastCharIndex);
        }
    }
}

