/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.AfterQueryCallbackInvoker;
import io.r2dbc.proxy.callback.DelegatingContextView;
import io.r2dbc.proxy.callback.MutableQueryExecutionInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.callback.QueriesExecutionContext;
import io.r2dbc.proxy.core.ProxyEventType;
import io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.spi.Result;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

class QueryInvocationSubscriber
implements CoreSubscriber<Result>,
Subscription,
Scannable,
Fuseable.QueueSubscription<Result> {
    private final CoreSubscriber<? super Result> delegate;
    private final MutableQueryExecutionInfo executionInfo;
    private final ProxyExecutionListener listener;
    private final QueriesExecutionContext queriesExecutionContext;
    private final AfterQueryCallbackInvoker afterQueryCallbackInvoker;
    private Subscription subscription;
    private boolean resultProduced;

    public QueryInvocationSubscriber(CoreSubscriber<? super Result> delegate, MutableQueryExecutionInfo executionInfo, ProxyConfig proxyConfig, QueriesExecutionContext queriesExecutionContext) {
        this.delegate = delegate;
        this.executionInfo = executionInfo;
        this.listener = proxyConfig.getListeners();
        this.queriesExecutionContext = queriesExecutionContext;
        this.afterQueryCallbackInvoker = new AfterQueryCallbackInvoker(this.executionInfo, this.queriesExecutionContext, this.listener);
    }

    public Context currentContext() {
        return this.delegate.currentContext();
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        this.beforeQuery();
        this.delegate.onSubscribe((Subscription)this);
    }

    public void onNext(Result result) {
        this.queriesExecutionContext.incrementProducedCount();
        this.resultProduced = true;
        this.executionInfo.setSuccess(true);
        this.delegate.onNext((Object)result);
    }

    public void onError(Throwable t) {
        this.executionInfo.setThrowable(t);
        this.executionInfo.setSuccess(false);
        this.queriesExecutionContext.markAllProduced();
        if (this.queriesExecutionContext.isQueryFinished()) {
            this.afterQuery();
        }
        this.delegate.onError(t);
    }

    public void onComplete() {
        this.queriesExecutionContext.markAllProduced();
        if (this.queriesExecutionContext.isQueryFinished()) {
            this.executionInfo.setSuccess(true);
            this.afterQuery();
        }
        this.delegate.onComplete();
    }

    public void request(long n) {
        this.subscription.request(n);
    }

    public void cancel() {
        this.queriesExecutionContext.markAllProduced();
        if (this.queriesExecutionContext.isQueryFinished()) {
            if (this.resultProduced) {
                this.executionInfo.setSuccess(true);
            }
            this.afterQuery();
        }
        this.subscription.cancel();
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.ACTUAL) {
            return this.delegate;
        }
        if (key == Scannable.Attr.PARENT) {
            return this.subscription;
        }
        return null;
    }

    public int requestFusion(int requestedMode) {
        return 0;
    }

    public Result poll() {
        return null;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public void clear() {
    }

    private void afterQuery() {
        this.afterQueryCallbackInvoker.afterQuery();
    }

    private void beforeQuery() {
        this.executionInfo.setThreadName(Thread.currentThread().getName());
        this.executionInfo.setThreadId(Thread.currentThread().getId());
        this.executionInfo.setCurrentMappedResult(null);
        this.executionInfo.setProxyEventType(ProxyEventType.BEFORE_QUERY);
        this.executionInfo.getValueStore().put(ContextView.class, new DelegatingContextView((ContextView)this.currentContext()));
        this.queriesExecutionContext.startStopwatch();
        this.listener.beforeQuery(this.executionInfo);
    }
}

