/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.CallbackHandlerSupport;
import io.r2dbc.proxy.callback.MutableQueryExecutionInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.core.ConnectionInfo;
import io.r2dbc.proxy.core.ProxyEventType;
import io.r2dbc.proxy.core.QueryExecutionInfo;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Result;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class ResultCallbackHandler
extends CallbackHandlerSupport {
    private final Result result;
    private final MutableQueryExecutionInfo queryExecutionInfo;

    public ResultCallbackHandler(Result result, QueryExecutionInfo queryExecutionInfo, ProxyConfig proxyConfig) {
        super(proxyConfig);
        this.result = Assert.requireNonNull(result, "result must not be null");
        Assert.requireNonNull(queryExecutionInfo, "queryExecutionInfo must not be null");
        this.queryExecutionInfo = Assert.requireType(queryExecutionInfo, MutableQueryExecutionInfo.class, "queryExecutionInfo must be MutableQueryExecutionInfo");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Assert.requireNonNull(proxy, "proxy must not be null");
        Assert.requireNonNull(method, "method must not be null");
        String methodName = method.getName();
        ConnectionInfo connectionInfo = this.queryExecutionInfo.getConnectionInfo();
        if ("unwrap".equals(methodName)) {
            return this.result;
        }
        if ("unwrapConnection".equals(methodName)) {
            return connectionInfo.getOriginalConnection();
        }
        Object invocationResult = this.proceedExecution(method, this.result, args, this.proxyConfig.getListeners(), connectionInfo, null);
        if ("map".equals(methodName)) {
            AtomicInteger resultCount = new AtomicInteger(0);
            return Flux.from((Publisher)((Publisher)invocationResult)).doOnEach(signal -> {
                boolean proceed;
                boolean bl = proceed = signal.isOnNext() || signal.isOnError();
                if (!proceed) {
                    return;
                }
                int count = resultCount.incrementAndGet();
                if (signal.isOnNext()) {
                    Object mappedResult = signal.get();
                    this.queryExecutionInfo.setCurrentResultCount(count);
                    this.queryExecutionInfo.setCurrentMappedResult(mappedResult);
                    this.queryExecutionInfo.setThrowable(null);
                } else {
                    Throwable thrown = signal.getThrowable();
                    this.queryExecutionInfo.setCurrentResultCount(count);
                    this.queryExecutionInfo.setCurrentMappedResult(null);
                    this.queryExecutionInfo.setThrowable(thrown);
                }
                this.queryExecutionInfo.setProxyEventType(ProxyEventType.EACH_QUERY_RESULT);
                String threadName = Thread.currentThread().getName();
                long threadId = Thread.currentThread().getId();
                this.queryExecutionInfo.setThreadName(threadName);
                this.queryExecutionInfo.setThreadId(threadId);
                this.proxyConfig.getListeners().eachQueryResult(this.queryExecutionInfo);
            });
        }
        return invocationResult;
    }
}

