/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.test;

import io.r2dbc.proxy.core.ConnectionInfo;
import io.r2dbc.proxy.core.StatementInfo;
import io.r2dbc.proxy.core.ValueStore;

public final class MockStatementInfo
implements StatementInfo {
    private ConnectionInfo connectionInfo;
    private String originalQuery;
    private String updatedQuery;
    private ValueStore valueStore;

    public static Builder builder() {
        return new Builder();
    }

    public static MockStatementInfo empty() {
        return MockStatementInfo.builder().build();
    }

    private MockStatementInfo(Builder builder) {
        this.connectionInfo = builder.connectionInfo;
        this.originalQuery = builder.originalQuery;
        this.updatedQuery = builder.updatedQuery;
        this.valueStore = builder.valueStore;
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public String getOriginalQuery() {
        return this.originalQuery;
    }

    @Override
    public String getUpdatedQuery() {
        return this.updatedQuery;
    }

    @Override
    public ValueStore getValueStore() {
        return this.valueStore;
    }

    public static final class Builder {
        private ConnectionInfo connectionInfo;
        private String originalQuery;
        private String updatedQuery;
        private ValueStore valueStore = ValueStore.create();

        public ConnectionInfo getConnectionInfo() {
            return this.connectionInfo;
        }

        public Builder connectionInfo(ConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        public Builder originalQuery(String originalQuery) {
            this.originalQuery = originalQuery;
            return this;
        }

        public Builder updatedQuery(String updatedQuery) {
            this.updatedQuery = updatedQuery;
            return this;
        }

        public Builder valueStore(ValueStore valueStore) {
            this.valueStore = valueStore;
            return this;
        }

        public MockStatementInfo build() {
            return new MockStatementInfo(this);
        }
    }
}

