/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.ConnectionIdManager;
import io.r2dbc.proxy.callback.JdkProxyFactoryFactory;
import io.r2dbc.proxy.callback.ProxyFactory;
import io.r2dbc.proxy.callback.ProxyFactoryFactory;
import io.r2dbc.proxy.listener.BindParameterConverter;
import io.r2dbc.proxy.listener.CompositeProxyExecutionListener;
import io.r2dbc.proxy.listener.LifeCycleExecutionListener;
import io.r2dbc.proxy.listener.LifeCycleListener;
import io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.proxy.util.Assert;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;

public class ProxyConfig {
    private static final ConnectionIdManager DEFAULT_CONNECTION_ID_MANAGER = ConnectionIdManager.create();
    private static final ProxyFactoryFactory DEFAULT_PROXY_FACTORY_FACTORY = new JdkProxyFactoryFactory();
    private static final BindParameterConverter DEFAULT_BIND_PARAMETER_CONVERTER = BindParameterConverter.create();
    private static final Clock DEFAULT_CLOCK = Clock.systemUTC();
    private final CompositeProxyExecutionListener listeners = new CompositeProxyExecutionListener(new ProxyExecutionListener[0]);
    private ConnectionIdManager connectionIdManager = DEFAULT_CONNECTION_ID_MANAGER;
    private ProxyFactory proxyFactory = DEFAULT_PROXY_FACTORY_FACTORY.create(this);
    private Clock clock = DEFAULT_CLOCK;
    private BindParameterConverter bindParameterConverter = DEFAULT_BIND_PARAMETER_CONVERTER;

    public static Builder builder() {
        return new Builder();
    }

    public ProxyConfig() {
    }

    private ProxyConfig(Builder builder) {
        this.connectionIdManager = builder.connectionIdManager;
        this.clock = builder.clock;
        this.listeners.addAll(builder.listeners);
        this.bindParameterConverter = builder.bindParameterConverter;
        this.proxyFactory = builder.proxyFactoryFactory.create(this);
    }

    public void setProxyFactoryFactory(ProxyFactoryFactory proxyFactoryFactory) {
        Assert.requireNonNull(proxyFactoryFactory, "proxyFactoryFactory must not be null");
        this.proxyFactory = proxyFactoryFactory.create(this);
    }

    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public CompositeProxyExecutionListener getListeners() {
        return this.listeners;
    }

    public void addListener(ProxyExecutionListener listener) {
        Assert.requireNonNull(listener, "listener must not be null");
        this.listeners.add(listener);
    }

    public ConnectionIdManager getConnectionIdManager() {
        return this.connectionIdManager;
    }

    public void setConnectionIdManager(ConnectionIdManager connectionIdManager) {
        this.connectionIdManager = Assert.requireNonNull(connectionIdManager, "connectionIdManager must not be null");
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = Assert.requireNonNull(clock, "clock must not be null");
    }

    public BindParameterConverter getBindParameterConverter() {
        return this.bindParameterConverter;
    }

    public void setBindParameterConverter(BindParameterConverter bindParameterConverter) {
        this.bindParameterConverter = Assert.requireNonNull(bindParameterConverter, "bindParameterConverter must not be null");
    }

    static /* synthetic */ ConnectionIdManager access$500() {
        return DEFAULT_CONNECTION_ID_MANAGER;
    }

    static /* synthetic */ ProxyFactoryFactory access$600() {
        return DEFAULT_PROXY_FACTORY_FACTORY;
    }

    static /* synthetic */ BindParameterConverter access$700() {
        return DEFAULT_BIND_PARAMETER_CONVERTER;
    }

    static /* synthetic */ Clock access$800() {
        return DEFAULT_CLOCK;
    }

    public static final class Builder {
        private List<ProxyExecutionListener> listeners = new ArrayList<ProxyExecutionListener>();
        private ConnectionIdManager connectionIdManager = ProxyConfig.access$500();
        private ProxyFactoryFactory proxyFactoryFactory = ProxyConfig.access$600();
        private BindParameterConverter bindParameterConverter = ProxyConfig.access$700();
        private Clock clock = ProxyConfig.access$800();

        public Builder listener(ProxyExecutionListener listener) {
            this.listeners.add(Assert.requireNonNull(listener, "listener must not be null"));
            return this;
        }

        public Builder listener(LifeCycleListener lifeCycleListener) {
            Assert.requireNonNull(lifeCycleListener, "lifeCycleListener must not be null");
            return this.listener(LifeCycleExecutionListener.of(lifeCycleListener));
        }

        public Builder connectionIdManager(ConnectionIdManager connectionIdManager) {
            this.connectionIdManager = Assert.requireNonNull(connectionIdManager, "connectionIdManager must not be null");
            return this;
        }

        public Builder proxyFactoryFactory(ProxyFactoryFactory proxyFactoryFactory) {
            this.proxyFactoryFactory = Assert.requireNonNull(proxyFactoryFactory, "proxyFactoryFactory must not be null");
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = Assert.requireNonNull(clock, "clock must not be null");
            return this;
        }

        public Builder bindParameterConverter(BindParameterConverter bindParameterConverter) {
            this.bindParameterConverter = Assert.requireNonNull(bindParameterConverter, "bindParameterConverter must not be null");
            return this;
        }

        public ProxyConfig build() {
            return new ProxyConfig(this);
        }
    }
}

