/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.function.Supplier;

final class StringArrayCodec
extends AbstractArrayCodec<String> {
    StringArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, String.class);
    }

    @Override
    public Parameter encodeNull() {
        return StringArrayCodec.createNull(PostgresqlObjectId.TEXT_ARRAY, Format.FORMAT_TEXT);
    }

    @Override
    String doDecodeBinary(ByteBuf byteBuffer) {
        return ByteBufUtils.decode(byteBuffer);
    }

    @Override
    String doDecodeText(String text) {
        return text;
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.BPCHAR_ARRAY == type || PostgresqlObjectId.CHAR_ARRAY == type || PostgresqlObjectId.TEXT_ARRAY == type || PostgresqlObjectId.VARCHAR_ARRAY == type;
    }

    @Override
    Parameter encodeArray(Supplier<ByteBuf> encodedSupplier) {
        return StringArrayCodec.create(PostgresqlObjectId.TEXT_ARRAY, Format.FORMAT_TEXT, encodedSupplier);
    }

    @Override
    String doEncodeText(String value) {
        Assert.requireNonNull(value, "value must not be null");
        return AbstractArrayCodec.escapeArrayElement(value);
    }
}

