/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.time.OffsetDateTime;
import reactor.util.annotation.Nullable;

final class OffsetDateTimeCodec
extends AbstractTemporalCodec<OffsetDateTime> {
    private final ByteBufAllocator byteBufAllocator;

    OffsetDateTimeCodec(ByteBufAllocator byteBufAllocator) {
        super(OffsetDateTime.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return OffsetDateTimeCodec.createNull(PostgresqlObjectId.TIMESTAMPTZ, Format.FORMAT_TEXT);
    }

    @Override
    OffsetDateTime doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends OffsetDateTime> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, OffsetDateTime.class, OffsetDateTime::from);
    }

    @Override
    Parameter doEncode(OffsetDateTime value) {
        Assert.requireNonNull(value, "value must not be null");
        return OffsetDateTimeCodec.create(PostgresqlObjectId.TIMESTAMPTZ, Format.FORMAT_TEXT, () -> ByteBufUtils.encode(this.byteBufAllocator, value.toString()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.TIMESTAMPTZ;
    }
}

