/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import reactor.util.annotation.Nullable;

final class LocalTimeCodec
extends AbstractTemporalCodec<LocalTime> {
    private final ByteBufAllocator byteBufAllocator;

    LocalTimeCodec(ByteBufAllocator byteBufAllocator) {
        super(LocalTime.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return LocalTimeCodec.createNull(PostgresqlObjectId.TIME, Format.FORMAT_TEXT);
    }

    @Override
    LocalTime doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, Class<? extends LocalTime> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, LocalTime.class, temporal -> {
            if (temporal instanceof LocalDateTime) {
                return ((LocalDateTime)temporal).toLocalTime();
            }
            return Instant.from(temporal).atOffset(ZoneOffset.UTC).toLocalTime();
        });
    }

    @Override
    Parameter doEncode(LocalTime value) {
        Assert.requireNonNull(value, "value must not be null");
        return LocalTimeCodec.create(PostgresqlObjectId.TIME, Format.FORMAT_TEXT, () -> ByteBufUtils.encode(this.byteBufAllocator, value.toString()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.TIME;
    }
}

