/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

abstract class AbstractCodec<T>
implements Codec<T> {
    private final Class<T> type;

    AbstractCodec(Class<T> type) {
        this.type = Assert.requireNonNull(type, "type must not be null");
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.isValid(dataType) && (type == Object.class || this.isTypeAssignable(type)) && this.doCanDecode(PostgresqlObjectId.valueOf(dataType), format);
    }

    @Override
    public boolean canEncode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.type.isInstance(value);
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return this.type.isAssignableFrom(type);
    }

    @Override
    @Nullable
    public final T decode(@Nullable ByteBuf buffer, int dataType, Format format, Class<? extends T> type) {
        if (buffer == null) {
            return null;
        }
        return this.doDecode(buffer, PostgresqlObjectId.valueOf(dataType), format, type);
    }

    @Override
    public final Parameter encode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.doEncode(value);
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    static Parameter create(PostgresqlObjectId type, Format format, Publisher<? extends ByteBuf> value) {
        return new Parameter(format, type.getObjectId(), value);
    }

    static Parameter create(PostgresqlObjectId type, Format format, Supplier<? extends ByteBuf> bufferSupplier) {
        return new Parameter(format, type.getObjectId(), (Publisher<? extends ByteBuf>)Mono.fromSupplier(bufferSupplier));
    }

    static Parameter createNull(PostgresqlObjectId type, Format format) {
        return AbstractCodec.create(type, format, Parameter.NULL_VALUE);
    }

    abstract boolean doCanDecode(PostgresqlObjectId var1, Format var2);

    abstract T doDecode(ByteBuf var1, PostgresqlObjectId var2, Format var3, Class<? extends T> var4);

    abstract Parameter doEncode(T var1);

    boolean isTypeAssignable(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return type.isAssignableFrom(this.type);
    }
}

