/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.StatementCache;
import io.r2dbc.postgresql.client.Binding;
import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.client.ExtendedQueryMessageFlow;
import io.r2dbc.postgresql.util.Assert;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Mono;

final class IndefiniteStatementCache
implements StatementCache {
    private final Map<String, Map<int[], Mono<String>>> cache = new ConcurrentHashMap<String, Map<int[], Mono<String>>>();
    private final Client client;
    private final AtomicInteger counter = new AtomicInteger();

    IndefiniteStatementCache(Client client) {
        this.client = Assert.requireNonNull(client, "client must not be null");
    }

    @Override
    public Mono<String> getName(Binding binding, String sql) {
        Assert.requireNonNull(binding, "binding must not be null");
        Assert.requireNonNull(sql, "sql must not be null");
        Map typedMap = this.cache.computeIfAbsent(sql, ignore -> new TreeMap((o1, o2) -> {
            if (Arrays.equals(o1, o2)) {
                return 0;
            }
            if (((int[])o1).length != ((int[])o2).length) {
                return ((int[])o1).length - ((int[])o2).length;
            }
            for (int i = 0; i < ((int[])o1).length; ++i) {
                int cmp = Integer.compare(o1[i], o2[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }));
        Mono<String> mono = (Mono<String>)typedMap.get(binding.getParameterTypes());
        if (mono == null) {
            mono = this.parse(sql, binding.getParameterTypes());
            typedMap.put(binding.getParameterTypes(), mono);
        }
        return mono;
    }

    public String toString() {
        return "IndefiniteStatementCache{cache=" + this.cache + ", client=" + this.client + ", counter=" + this.counter + '}';
    }

    private Mono<String> parse(String sql, int[] types) {
        String name = "S_" + this.counter.getAndIncrement();
        ExceptionFactory factory = ExceptionFactory.withSql(sql);
        return ExtendedQueryMessageFlow.parse(this.client, name, sql, types).handle(factory::handleErrorResponse).then(Mono.just((Object)name)).cache();
    }
}

