/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.ArrayCodec;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.Decoder;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.EnumSet;
import java.util.Set;
import reactor.util.annotation.Nullable;

final class StringCodec
extends AbstractCodec<String> {
    static final Codec<String> STRING_DECODER = StringDecoder.INSTANCE;
    static final Codec<String[]> STRING_ARRAY_DECODER = StringArrayDecoder.INSTANCE;
    private static final Set<PostgresqlObjectId> SUPPORTED_TYPES = EnumSet.of(PostgresqlObjectId.BPCHAR, new PostgresqlObjectId[]{PostgresqlObjectId.CHAR, PostgresqlObjectId.TEXT, PostgresqlObjectId.UNKNOWN, PostgresqlObjectId.VARCHAR, PostgresqlObjectId.NAME});
    private final ByteBufAllocator byteBufAllocator;

    StringCodec(ByteBufAllocator byteBufAllocator) {
        super(String.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return StringCodec.createNull(PostgresqlObjectId.VARCHAR, Format.FORMAT_TEXT);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return SUPPORTED_TYPES.contains((Object)type);
    }

    @Override
    String doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends String> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return ByteBufUtils.decode(buffer);
    }

    @Override
    Parameter doEncode(String value) {
        Assert.requireNonNull(value, "value must not be null");
        return StringCodec.create(PostgresqlObjectId.VARCHAR, Format.FORMAT_TEXT, () -> ByteBufUtils.encode(this.byteBufAllocator, value));
    }

    @Override
    public Iterable<PostgresqlObjectId> getDataTypes() {
        return SUPPORTED_TYPES;
    }

    private static class StringArrayDecoder
    implements Codec<String[]> {
        static final StringArrayDecoder INSTANCE = new StringArrayDecoder();

        private StringArrayDecoder() {
        }

        @Override
        public boolean canDecode(int dataType, Format format, Class<?> type) {
            Assert.requireNonNull(type, "type must not be null");
            return type.isAssignableFrom(String[].class);
        }

        @Override
        public boolean canEncode(Object value) {
            return false;
        }

        @Override
        public boolean canEncodeNull(Class<?> type) {
            return false;
        }

        @Override
        public String[] decode(ByteBuf buffer, int dataType, Format format, Class<? extends String[]> type) {
            Assert.requireNonNull(buffer, "byteBuf must not be null");
            Assert.requireNonNull(format, "format must not be null");
            Assert.requireNonNull(type, "type must not be null");
            if (Format.FORMAT_BINARY == format) {
                return ArrayCodec.decodeBinary(buffer, dataType, StringDecoder.INSTANCE, String.class, type);
            }
            return ArrayCodec.decodeText(buffer, dataType, (byte)44, StringDecoder.INSTANCE, String.class, type);
        }

        @Override
        public Parameter encode(Object value) {
            throw new UnsupportedOperationException("Cannot encode using a generic enum codec");
        }

        @Override
        public Parameter encodeNull() {
            throw new UnsupportedOperationException("Cannot encode using a generic enum codec");
        }
    }

    private static class StringDecoder
    implements Codec<String>,
    Decoder<String> {
        static final StringDecoder INSTANCE = new StringDecoder();

        StringDecoder() {
        }

        @Override
        public boolean canDecode(int dataType, Format format, Class<?> type) {
            Assert.requireNonNull(type, "type must not be null");
            return type.isAssignableFrom(String.class);
        }

        @Override
        public boolean canEncode(Object value) {
            return false;
        }

        @Override
        public boolean canEncodeNull(Class<?> type) {
            return false;
        }

        @Override
        public String decode(@Nullable ByteBuf buffer, int dataType, Format format, Class<? extends String> type) {
            Assert.requireNonNull(buffer, "byteBuf must not be null");
            return ByteBufUtils.decode(buffer);
        }

        @Override
        public Parameter encode(Object value) {
            throw new UnsupportedOperationException("Cannot encode using a generic enum codec");
        }

        @Override
        public Parameter encodeNull() {
            throw new UnsupportedOperationException("Cannot encode using a generic enum codec");
        }
    }
}

