/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.api.PostgresqlConnection;
import io.r2dbc.postgresql.api.PostgresqlStatement;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.CodecRegistry;
import io.r2dbc.postgresql.codec.HStoreCodec;
import io.r2dbc.postgresql.extension.CodecRegistrar;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.util.annotation.Nullable;

public class BuiltinDynamicCodecs
implements CodecRegistrar {
    private static final Object EMPTY = new Object();

    @Override
    public Publisher<Void> register(PostgresqlConnection connection, ByteBufAllocator byteBufAllocator, CodecRegistry registry) {
        PostgresqlStatement statement = this.createQuery(connection);
        return statement.execute().flatMap(it -> it.map((row, rowMetadata) -> {
            int oid = PostgresqlObjectId.toInt((Long)row.get("oid", Long.class));
            String typname = (String)row.get("typname", String.class);
            BuiltinCodec lookup = BuiltinCodec.lookup(typname);
            registry.addLast(lookup.createCodec(byteBufAllocator, oid));
            return EMPTY;
        })).then();
    }

    private PostgresqlStatement createQuery(PostgresqlConnection connection) {
        return connection.createStatement(String.format("SELECT oid, typname FROM pg_catalog.pg_type WHERE typname IN (%s)", BuiltinDynamicCodecs.getPlaceholders()));
    }

    private static String getPlaceholders() {
        return Arrays.stream(BuiltinCodec.values()).map(s -> "'" + s.getName() + "'").collect(Collectors.joining(","));
    }

    static enum BuiltinCodec {
        HSTORE("hstore");

        private final String name;

        private BuiltinCodec(String name) {
            this.name = name;
        }

        public Codec<?> createCodec(ByteBufAllocator byteBufAllocator, int oid) {
            switch (this) {
                case HSTORE: {
                    return new HStoreCodec(byteBufAllocator, oid);
                }
            }
            throw new UnsupportedOperationException(String.format("Codec %s for OID %d not supported", this.name(), oid));
        }

        public String getName() {
            return this.name;
        }

        static BuiltinCodec lookup(@Nullable String name) {
            for (BuiltinCodec codec : BuiltinCodec.values()) {
                if (!codec.getName().equalsIgnoreCase(name)) continue;
                return codec;
            }
            throw new IllegalArgumentException(String.format("Cannot determine codec for %s", name));
        }
    }
}

