/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.type;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;

public final class Length {
    public static final int USHORT_NULL = 65535;
    public static final int UNKNOWN_STREAM_LENGTH = -1;
    private static final int CACHE_ENTRIES = 1024;
    private static final Length NULL;
    private static final Length[] CACHE;
    private static final Length UNKNOWN_NULL;
    private static final Length UNKNOWN;
    private final int length;
    private final boolean isNull;

    private Length(int length, boolean isNull) {
        this.length = length;
        this.isNull = isNull;
    }

    public static Length nullLength() {
        return Length.of(0, true);
    }

    public static Length of(int length) {
        return Length.of(length, false);
    }

    public static Length of(int length, boolean isNull) {
        if (length == -1) {
            return isNull ? UNKNOWN_NULL : UNKNOWN;
        }
        if (isNull) {
            return NULL;
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be greater or equal to zero");
        }
        if (length > 1023) {
            return new Length(length, isNull);
        }
        return CACHE[length];
    }

    public static Length decode(ByteBuf buffer, TypeInformation type) {
        switch (type.getLengthStrategy()) {
            case PARTLENTYPE: {
                int length = Decode.asInt(buffer);
                return Length.of(length, false);
            }
            case FIXEDLENTYPE: {
                return Length.of(type.getMaxLength(), type.getMaxLength() == 0);
            }
            case BYTELENTYPE: {
                int length = Decode.uByte(buffer);
                return Length.of(length, length == 0);
            }
            case USHORTLENTYPE: {
                int length = Decode.uShort(buffer);
                return Length.of(length == 65535 ? 0 : length, length == 65535);
            }
            case LONGLENTYPE: {
                SqlServerType serverType = type.getServerType();
                if (serverType == SqlServerType.TEXT || serverType == SqlServerType.IMAGE || serverType == SqlServerType.NTEXT) {
                    int nullMarker = Decode.uByte(buffer);
                    if (nullMarker == 0) {
                        return new Length(0, true);
                    }
                    buffer.skipBytes(24);
                    int valueLength = Decode.asLong(buffer);
                    return Length.of(valueLength, false);
                }
                if (serverType == SqlServerType.SQL_VARIANT) {
                    int valueLength;
                    return Length.of(valueLength, (valueLength = Decode.asInt(buffer)) == 0);
                }
                int length = Decode.uShort(buffer);
                return Length.of(length == 65535 ? 0 : length, length == 65535);
            }
        }
        throw ProtocolException.invalidTds("Cannot parse value LengthDescriptor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDecode(ByteBuf buffer, TypeInformation type) {
        int readerIndex = buffer.readerIndex();
        try {
            boolean bl = Length.doCanDecode(buffer, type);
            return bl;
        }
        finally {
            buffer.readerIndex(readerIndex);
        }
    }

    private static boolean doCanDecode(ByteBuf buffer, TypeInformation type) {
        switch (type.getLengthStrategy()) {
            case PARTLENTYPE: {
                return buffer.readableBytes() >= 4;
            }
            case FIXEDLENTYPE: {
                return true;
            }
            case BYTELENTYPE: 
            case USHORTLENTYPE: {
                return buffer.readableBytes() >= 2;
            }
            case LONGLENTYPE: {
                SqlServerType serverType = type.getServerType();
                if (serverType == SqlServerType.TEXT || serverType == SqlServerType.IMAGE || serverType == SqlServerType.NTEXT) {
                    if (buffer.readableBytes() == 0) {
                        return false;
                    }
                    int nullMarker = Decode.uByte(buffer);
                    if (nullMarker == 0) {
                        return true;
                    }
                    return buffer.readableBytes() >= 28;
                }
                if (serverType == SqlServerType.SQL_VARIANT) {
                    return buffer.readableBytes() >= 4;
                }
                return buffer.readableBytes() >= 2;
            }
        }
        throw ProtocolException.invalidTds("Cannot parse value LengthDescriptor");
    }

    public void encode(ByteBuf buffer, TypeInformation type) {
        LengthStrategy lengthStrategy = type.getLengthStrategy();
        if (lengthStrategy == LengthStrategy.LONGLENTYPE) {
            SqlServerType serverType = type.getServerType();
            if (serverType == SqlServerType.TEXT || serverType == SqlServerType.IMAGE || serverType == SqlServerType.NTEXT) {
                if (this.isNull()) {
                    Encode.asByte(buffer, (byte)0);
                    return;
                }
                buffer.skipBytes(24);
                buffer.writeLong((long)this.getLength());
                return;
            }
            if (serverType == SqlServerType.SQL_VARIANT) {
                Encode.intBigEndian(buffer, this.getLength());
                return;
            }
            if (this.isNull()) {
                Encode.uShortBE(buffer, 65535);
            } else {
                Encode.uShortBE(buffer, this.getLength());
            }
            return;
        }
        this.encode(buffer, lengthStrategy);
    }

    public void encode(ByteBuf buffer, LengthStrategy lengthStrategy) {
        switch (lengthStrategy) {
            case PARTLENTYPE: {
                Encode.asInt(buffer, this.getLength());
                return;
            }
            case FIXEDLENTYPE: {
                return;
            }
            case BYTELENTYPE: {
                if (this.isNull()) {
                    Encode.asByte(buffer, (byte)0);
                } else {
                    Encode.asByte(buffer, (byte)this.getLength());
                }
                return;
            }
            case USHORTLENTYPE: {
                if (this.isNull()) {
                    Encode.uShort(buffer, 65535);
                } else {
                    Encode.uShort(buffer, this.getLength());
                }
                return;
            }
        }
        throw ProtocolException.invalidTds("Cannot encode value LengthDescriptor for " + (Object)((Object)lengthStrategy));
    }

    public int getLength() {
        return this.length;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [length=").append(this.length);
        sb.append(", isNull=").append(this.isNull);
        sb.append(']');
        return sb.toString();
    }

    static {
        CACHE = new Length[1024];
        for (int i = 0; i < 1024; ++i) {
            Length.CACHE[i] = new Length(i, false);
        }
        NULL = new Length(0, true);
        UNKNOWN = new Length(-1, false);
        UNKNOWN_NULL = new Length(-1, true);
    }
}

