/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.client;

import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.client.ConnectionContext;
import io.r2dbc.mssql.client.TransactionStatus;
import io.r2dbc.mssql.message.ClientMessage;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.TransactionDescriptor;
import io.r2dbc.mssql.message.tds.Redirect;
import io.r2dbc.mssql.message.type.Collation;
import java.util.Optional;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface Client {
    public Mono<Void> attention();

    public Mono<Void> close();

    public Flux<Message> exchange(Publisher<? extends ClientMessage> var1, Predicate<Message> var2);

    public ByteBufAllocator getByteBufAllocator();

    public ConnectionContext getContext();

    public Optional<Collation> getDatabaseCollation();

    public Optional<String> getDatabaseVersion();

    public Optional<Redirect> getRedirect();

    public TransactionDescriptor getTransactionDescriptor();

    public TransactionStatus getTransactionStatus();

    default public Collation getRequiredCollation() {
        return this.getDatabaseCollation().orElseThrow(() -> new IllegalStateException("Collation not available"));
    }

    public boolean isColumnEncryptionSupported();

    public boolean isConnected();
}

