/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.r2dbc.mssql.ConnectionOptions;
import io.r2dbc.mssql.IndefinitePreparedStatementCache;
import io.r2dbc.mssql.LoginConfiguration;
import io.r2dbc.mssql.client.ClientConfiguration;
import io.r2dbc.mssql.client.ssl.ExpectedHostnameX509TrustManager;
import io.r2dbc.mssql.client.ssl.SslConfiguration;
import io.r2dbc.mssql.client.ssl.TrustAllTrustManager;
import io.r2dbc.mssql.codec.DefaultCodecs;
import io.r2dbc.mssql.message.tds.Redirect;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.mssql.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import reactor.netty.resources.ConnectionProvider;
import reactor.util.annotation.Nullable;

public final class MssqlConnectionConfiguration {
    public static final int DEFAULT_PORT = 1433;
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(30L);
    @Nullable
    private final String applicationName;
    @Nullable
    private final UUID connectionId;
    private final Duration connectTimeout;
    private final String database;
    private final String host;
    private final String hostNameInCertificate;
    private final CharSequence password;
    private final Predicate<String> preferCursoredExecution;
    @Nullable
    private final Duration lockWaitTimeout;
    private final int port;
    private final boolean sendStringParametersAsUnicode;
    private final boolean ssl;
    private final Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer;
    @Nullable
    private final Function<SslContextBuilder, SslContextBuilder> sslTunnelSslContextBuilderCustomizer;
    private final boolean tcpKeepAlive;
    private final boolean tcpNoDelay;
    private final boolean trustServerCertificate;
    @Nullable
    private final File trustStore;
    @Nullable
    private final String trustStoreType;
    @Nullable
    private final char[] trustStorePassword;
    private final String username;

    private MssqlConnectionConfiguration(@Nullable String applicationName, @Nullable UUID connectionId, Duration connectTimeout, @Nullable String database, String host, String hostNameInCertificate, @Nullable Duration lockWaitTimeout, CharSequence password, Predicate<String> preferCursoredExecution, int port, boolean sendStringParametersAsUnicode, boolean ssl, Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer, @Nullable Function<SslContextBuilder, SslContextBuilder> sslTunnelSslContextBuilderCustomizer, boolean tcpKeepAlive, boolean tcpNoDelay, boolean trustServerCertificate, @Nullable File trustStore, @Nullable String trustStoreType, @Nullable char[] trustStorePassword, String username) {
        this.applicationName = applicationName;
        this.connectionId = connectionId;
        this.connectTimeout = Assert.requireNonNull(connectTimeout, "connect timeout must not be null");
        this.database = database;
        this.host = Assert.requireNonNull(host, "host must not be null");
        this.hostNameInCertificate = Assert.requireNonNull(hostNameInCertificate, "hostNameInCertificate must not be null");
        this.lockWaitTimeout = lockWaitTimeout;
        this.password = Assert.requireNonNull(password, "password must not be null");
        this.preferCursoredExecution = Assert.requireNonNull(preferCursoredExecution, "preferCursoredExecution must not be null");
        this.port = port;
        this.sendStringParametersAsUnicode = sendStringParametersAsUnicode;
        this.ssl = ssl;
        this.sslContextBuilderCustomizer = sslContextBuilderCustomizer;
        this.sslTunnelSslContextBuilderCustomizer = sslTunnelSslContextBuilderCustomizer;
        this.tcpKeepAlive = tcpKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.trustServerCertificate = trustServerCertificate;
        this.trustStore = trustStore;
        this.trustStoreType = trustStoreType;
        this.trustStorePassword = trustStorePassword;
        this.username = Assert.requireNonNull(username, "username must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    MssqlConnectionConfiguration withRedirect(Redirect redirect) {
        boolean trustedDomain;
        String redirectServerName = redirect.getServerName();
        String hostNameInCertificate = this.hostNameInCertificate;
        if (this.hostNameInCertificate.startsWith("*") && redirectServerName.indexOf(46) != -1 && (trustedDomain = redirectServerName.endsWith(hostNameInCertificate.substring(1)))) {
            hostNameInCertificate = String.format("*%s", redirectServerName.substring(redirectServerName.indexOf(46)));
        }
        return new MssqlConnectionConfiguration(this.applicationName, this.connectionId, this.connectTimeout, this.database, redirectServerName, hostNameInCertificate, this.lockWaitTimeout, this.password, this.preferCursoredExecution, redirect.getPort(), this.sendStringParametersAsUnicode, this.ssl, this.sslContextBuilderCustomizer, this.sslTunnelSslContextBuilderCustomizer, this.tcpKeepAlive, this.tcpNoDelay, this.trustServerCertificate, this.trustStore, this.trustStoreType, this.trustStorePassword, this.username);
    }

    ClientConfiguration toClientConfiguration() {
        return new DefaultClientConfiguration(this.connectTimeout, this.host, this.hostNameInCertificate, this.port, this.ssl, this.sslContextBuilderCustomizer, this.sslTunnelSslContextBuilderCustomizer, this.tcpKeepAlive, this.tcpNoDelay, this.trustServerCertificate, this.trustStore, this.trustStoreType, this.trustStorePassword);
    }

    ConnectionOptions toConnectionOptions() {
        return new ConnectionOptions(this.preferCursoredExecution, new DefaultCodecs(), new IndefinitePreparedStatementCache(), this.sendStringParametersAsUnicode);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [applicationName=\"").append(this.applicationName).append('\"');
        sb.append(", connectionId=").append(this.connectionId);
        sb.append(", connectTimeout=\"").append(this.connectTimeout).append('\"');
        sb.append(", database=\"").append(this.database).append('\"');
        sb.append(", host=\"").append(this.host).append('\"');
        sb.append(", hostNameInCertificate=\"").append(this.hostNameInCertificate).append('\"');
        sb.append(", lockWaitTimeout=\"").append(this.lockWaitTimeout).append('\"');
        sb.append(", password=\"").append(MssqlConnectionConfiguration.repeat(this.password.length(), "*")).append('\"');
        sb.append(", preferCursoredExecution=\"").append(this.preferCursoredExecution).append('\"');
        sb.append(", port=").append(this.port);
        sb.append(", sendStringParametersAsUnicode=").append(this.sendStringParametersAsUnicode);
        sb.append(", ssl=").append(this.ssl);
        sb.append(", sslContextBuilderCustomizer=").append(this.sslContextBuilderCustomizer);
        sb.append(", sslTunnelSslContextBuilderCustomizer=").append(this.sslTunnelSslContextBuilderCustomizer);
        sb.append(", tcpKeepAlive=\"").append(this.tcpKeepAlive).append("\"");
        sb.append(", tcpNoDelay=\"").append(this.tcpNoDelay).append("\"");
        sb.append(", trustServerCertificate=").append(this.trustServerCertificate);
        sb.append(", trustStore=\"").append(this.trustStore).append("\"");
        sb.append(", trustStorePassword=\"").append(MssqlConnectionConfiguration.repeat(this.trustStorePassword == null ? 0 : this.trustStorePassword.length, "*")).append('\"');
        sb.append(", trustStoreType=\"").append(this.trustStoreType).append("\"");
        sb.append(", username=\"").append(this.username).append('\"');
        sb.append(']');
        return sb.toString();
    }

    @Nullable
    String getApplicationName() {
        return this.applicationName;
    }

    @Nullable
    UUID getConnectionId() {
        return this.connectionId;
    }

    Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    Optional<String> getDatabase() {
        return Optional.ofNullable(this.database);
    }

    String getHost() {
        return this.host;
    }

    String getHostNameInCertificate() {
        return this.hostNameInCertificate;
    }

    @Nullable
    Duration getLockWaitTimeout() {
        return this.lockWaitTimeout;
    }

    CharSequence getPassword() {
        return this.password;
    }

    Predicate<String> getPreferCursoredExecution() {
        return this.preferCursoredExecution;
    }

    int getPort() {
        return this.port;
    }

    boolean isSendStringParametersAsUnicode() {
        return this.sendStringParametersAsUnicode;
    }

    boolean useSsl() {
        return this.ssl;
    }

    boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    String getUsername() {
        return this.username;
    }

    LoginConfiguration getLoginConfiguration() {
        return new LoginConfiguration(this.getApplicationName(), this.connectionId, this.getDatabase().orElse(""), MssqlConnectionConfiguration.lookupHostName(), this.getPassword(), this.getHost(), this.useSsl(), this.getUsername());
    }

    private static String repeat(int length, String character) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(character);
        }
        return builder.toString();
    }

    private static String lookupHostName() {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            if (localAddress != null) {
                String value = localAddress.getHostName();
                if (StringUtils.hasText(value)) {
                    return value;
                }
                value = localAddress.getHostAddress();
                if (StringUtils.hasText(value)) {
                    return value;
                }
            }
        }
        catch (UnknownHostException e) {
            return "";
        }
        return "";
    }

    private static SslContextBuilder createSslContextBuilder() {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
        sslContextBuilder.sslProvider(OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).applicationProtocolConfig(null);
        return sslContextBuilder;
    }

    static class DefaultCursorPreference
    implements Predicate<String> {
        static final DefaultCursorPreference INSTANCE = new DefaultCursorPreference();

        DefaultCursorPreference() {
        }

        @Override
        public boolean test(String sql) {
            if (sql.isEmpty()) {
                return false;
            }
            String lc = sql.trim().toLowerCase(Locale.ENGLISH);
            if (lc.contains("for xml") || lc.contains("for json")) {
                return false;
            }
            char c = sql.charAt(0);
            return (c == 's' || c == 'S') && lc.startsWith("select");
        }
    }

    static class DefaultClientConfiguration
    implements ClientConfiguration {
        private final Duration connectTimeout;
        private final String host;
        private final String hostNameInCertificate;
        private final int port;
        private final boolean ssl;
        private final Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer;
        @Nullable
        private final Function<SslContextBuilder, SslContextBuilder> sslTunnelSslContextBuilderCustomizer;
        private final boolean tcpKeepAlive;
        private final boolean tcpNoDelay;
        private final boolean trustServerCertificate;
        @Nullable
        private final File trustStore;
        @Nullable
        private final String trustStoreType;
        @Nullable
        private final char[] trustStorePassword;

        DefaultClientConfiguration(Duration connectTimeout, String host, String hostNameInCertificate, int port, boolean ssl, Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer, @Nullable Function<SslContextBuilder, SslContextBuilder> sslTunnelSslContextBuilderCustomizer, boolean tcpKeepAlive, boolean tcpNoDelay, boolean trustServerCertificate, @Nullable File trustStore, @Nullable String trustStoreType, @Nullable char[] trustStorePassword) {
            this.connectTimeout = connectTimeout;
            this.host = host;
            this.hostNameInCertificate = hostNameInCertificate;
            this.port = port;
            this.ssl = ssl;
            this.sslContextBuilderCustomizer = sslContextBuilderCustomizer;
            this.sslTunnelSslContextBuilderCustomizer = sslTunnelSslContextBuilderCustomizer;
            this.tcpKeepAlive = tcpKeepAlive;
            this.tcpNoDelay = tcpNoDelay;
            this.trustServerCertificate = trustServerCertificate;
            this.trustStore = trustStore;
            this.trustStoreType = trustStoreType;
            this.trustStorePassword = trustStorePassword;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        @Override
        public boolean isTcpKeepAlive() {
            return this.tcpKeepAlive;
        }

        @Override
        public boolean isTcpNoDelay() {
            return this.tcpNoDelay;
        }

        @Override
        public ConnectionProvider getConnectionProvider() {
            return ConnectionProvider.newConnection();
        }

        @Override
        public boolean isSslEnabled() {
            return this.ssl;
        }

        @Override
        public SslContext getSslContext() throws GeneralSecurityException {
            SslContextBuilder sslContextBuilder = MssqlConnectionConfiguration.createSslContextBuilder();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore ks = this.loadCustomTrustStore();
            tmf.init(ks);
            TrustManager[] trustManagers = tmf.getTrustManagers();
            X509TrustManager result = this.isSslEnabled() && !this.trustServerCertificate ? new ExpectedHostnameX509TrustManager((X509TrustManager)trustManagers[0], this.hostNameInCertificate) : TrustAllTrustManager.INSTANCE;
            sslContextBuilder.trustManager((TrustManager)result);
            try {
                return this.sslContextBuilderCustomizer.apply(sslContextBuilder).build();
            }
            catch (SSLException e) {
                throw new GeneralSecurityException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        KeyStore loadCustomTrustStore() throws GeneralSecurityException {
            if (this.trustStore == null) {
                return null;
            }
            KeyStore trustStoreInstance = KeyStore.getInstance(this.trustStoreType == null ? KeyStore.getDefaultType() : this.trustStoreType);
            try (FileInputStream fis = new FileInputStream(this.trustStore);){
                trustStoreInstance.load(fis, this.trustStorePassword);
                KeyStore keyStore = trustStoreInstance;
                return keyStore;
            }
            catch (IOException e) {
                throw new GeneralSecurityException(String.format("Could not load custom trust store from %s", this.trustStore), e);
            }
        }

        @Override
        public SslConfiguration getSslTunnelConfiguration() {
            if (this.sslTunnelSslContextBuilderCustomizer == null) {
                return ClientConfiguration.super.getSslTunnelConfiguration();
            }
            return new SslConfiguration(){

                @Override
                public boolean isSslEnabled() {
                    return true;
                }

                @Override
                public SslContext getSslContext() throws GeneralSecurityException {
                    SslContextBuilder sslContextBuilder = MssqlConnectionConfiguration.createSslContextBuilder();
                    try {
                        return ((SslContextBuilder)sslTunnelSslContextBuilderCustomizer.apply(sslContextBuilder)).build();
                    }
                    catch (SSLException e) {
                        throw new GeneralSecurityException(e);
                    }
                }
            };
        }
    }

    public static final class Builder {
        @Nullable
        private String applicationName;
        private UUID connectionId = UUID.randomUUID();
        private Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT;
        private String database;
        private String host;
        private String hostNameInCertificate;
        @Nullable
        private Duration lockWaitTimeout;
        private Predicate<String> preferCursoredExecution = DefaultCursorPreference.INSTANCE;
        private CharSequence password;
        private int port = 1433;
        private boolean sendStringParametersAsUnicode = true;
        private boolean ssl;
        private boolean trustServerCertificate;
        private Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer = Function.identity();
        @Nullable
        private Function<SslContextBuilder, SslContextBuilder> sslTunnelSslContextBuilderCustomizer;
        private String username;
        private boolean tcpKeepAlive = false;
        private boolean tcpNoDelay = true;
        @Nullable
        private File trustStore;
        @Nullable
        private String trustStoreType;
        @Nullable
        private char[] trustStorePassword;

        private Builder() {
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = Assert.requireNonNull(applicationName, "applicationName must not be null");
            return this;
        }

        public Builder connectionId(UUID connectionId) {
            this.connectionId = Assert.requireNonNull(connectionId, "connectionId must not be null");
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            Assert.requireNonNull(connectTimeout, "connect timeout must not be null");
            Assert.isTrue(!connectTimeout.isNegative(), "connect timeout must not be negative");
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder database(@Nullable String database) {
            this.database = database;
            return this;
        }

        public Builder enableSsl() {
            this.ssl = true;
            return this;
        }

        public Builder enableSslTunnel() {
            return this.enableSslTunnel(Function.identity());
        }

        public Builder enableSslTunnel(Function<SslContextBuilder, SslContextBuilder> sslTunnelSslContextBuilderCustomizer) {
            this.sslTunnelSslContextBuilderCustomizer = Assert.requireNonNull(sslTunnelSslContextBuilderCustomizer, "sslTunnelSslContextBuilderCustomizer must not be null");
            return this;
        }

        public Builder host(String host) {
            this.host = Assert.requireNonNull(host, "host must not be null");
            return this;
        }

        public Builder hostNameInCertificate(String hostNameInCertificate) {
            this.hostNameInCertificate = Assert.requireNonNull(hostNameInCertificate, "hostNameInCertificate must not be null");
            return this;
        }

        public Builder lockWaitTimeout(Duration timeout) {
            Assert.requireNonNull(timeout, "lock wait timeout must not be null");
            this.lockWaitTimeout = timeout;
            return this;
        }

        public Builder password(CharSequence password) {
            this.password = Assert.requireNonNull(password, "password must not be null");
            return this;
        }

        public Builder preferCursoredExecution(boolean preferCursoredExecution) {
            return this.preferCursoredExecution(sql -> preferCursoredExecution);
        }

        public Builder preferCursoredExecution(Predicate<String> preference) {
            this.preferCursoredExecution = Assert.requireNonNull(preference, "Predicate must not be null");
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder sendStringParametersAsUnicode(boolean sendStringParametersAsUnicode) {
            this.sendStringParametersAsUnicode = sendStringParametersAsUnicode;
            return this;
        }

        public Builder sslContextBuilderCustomizer(Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer) {
            this.sslContextBuilderCustomizer = Assert.requireNonNull(sslContextBuilderCustomizer, "sslContextBuilderCustomizer must not be null");
            return this;
        }

        public Builder tcpKeepAlive(boolean enabled) {
            this.tcpKeepAlive = enabled;
            return this;
        }

        public Builder tcpNoDelay(boolean enabled) {
            this.tcpNoDelay = enabled;
            return this;
        }

        public Builder trustServerCertificate() {
            return this.trustServerCertificate(true);
        }

        public Builder trustServerCertificate(boolean trustServerCertificate) {
            this.trustServerCertificate = trustServerCertificate;
            return this;
        }

        public Builder trustStoreType(String trustStoreType) {
            this.trustStoreType = Assert.requireNonNull(trustStoreType, "trustStoreType must not be null");
            return this;
        }

        public Builder trustStore(String trustStoreFile) {
            return this.trustStore(new File(Assert.requireNonNull(trustStoreFile, "trustStore must not be null")));
        }

        public Builder trustStore(File trustStore) {
            this.trustStore = Assert.requireNonNull(trustStore, "trustStore must not be null");
            return this;
        }

        public Builder trustStorePassword(char[] trustStorePassword) {
            this.trustStorePassword = Assert.requireNonNull(Arrays.copyOf(trustStorePassword, trustStorePassword.length), "trustStorePassword must not be null");
            return this;
        }

        public Builder username(String username) {
            this.username = Assert.requireNonNull(username, "username must not be null");
            return this;
        }

        public MssqlConnectionConfiguration build() {
            if (this.hostNameInCertificate == null) {
                this.hostNameInCertificate = this.host;
            }
            return new MssqlConnectionConfiguration(this.applicationName, this.connectionId, this.connectTimeout, this.database, this.host, this.hostNameInCertificate, this.lockWaitTimeout, this.password, this.preferCursoredExecution, this.port, this.sendStringParametersAsUnicode, this.ssl, this.sslContextBuilderCustomizer, this.sslTunnelSslContextBuilderCustomizer, this.tcpKeepAlive, this.tcpNoDelay, this.trustServerCertificate, this.trustStore, this.trustStoreType, this.trustStorePassword, this.username);
        }
    }
}

