/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.ServerCharset;
import io.r2dbc.mssql.message.token.AbstractDataToken;
import io.r2dbc.mssql.util.Assert;
import reactor.util.annotation.Nullable;

public final class EnvChangeToken
extends AbstractDataToken {
    public static final byte TYPE = -29;
    private final int length;
    private final EnvChangeType changeType;
    private final byte[] newValue;
    private final byte[] oldValue;

    public EnvChangeToken(int length, EnvChangeType changeType, byte[] newValue, @Nullable byte[] oldValue) {
        super((byte)-29);
        Assert.requireNonNull(changeType, "EnvChangeType must not be null");
        Assert.requireNonNull(newValue, "New value must not be null");
        this.length = length;
        this.changeType = changeType;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    public static EnvChangeToken decode(ByteBuf buffer) {
        byte[] oldValue;
        byte[] newValue;
        int length = Decode.uShort(buffer);
        byte type = Decode.asByte(buffer);
        EnvChangeType envChangeType = EnvChangeType.valueOf(type);
        if (envChangeType == EnvChangeType.Routing) {
            newValue = new byte[length - 1];
            buffer.readBytes(newValue);
            oldValue = null;
        } else {
            int newValueLen = envChangeType.toByteLength(Decode.asByte(buffer));
            newValue = new byte[newValueLen];
            buffer.readBytes(newValue);
            int oldValueLen = envChangeType.toByteLength(Decode.asByte(buffer));
            oldValue = new byte[oldValueLen];
            buffer.readBytes(oldValue);
        }
        return new EnvChangeToken(length, envChangeType, newValue, oldValue);
    }

    public static boolean canDecode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        Integer requiredLength = Decode.peekUShort(buffer);
        return requiredLength != null && buffer.readableBytes() >= requiredLength + 2;
    }

    @Override
    public String getName() {
        return "ENVCHANGE_TOKEN";
    }

    public int getLength() {
        return this.length;
    }

    public EnvChangeType getChangeType() {
        return this.changeType;
    }

    public byte[] getNewValue() {
        return this.newValue;
    }

    @Nullable
    public byte[] getOldValue() {
        return this.oldValue;
    }

    public String getOldValueString() {
        return new String(this.oldValue, 0, this.oldValue.length, ServerCharset.UNICODE.charset());
    }

    public String getNewValueString() {
        return new String(this.newValue, 0, this.newValue.length, ServerCharset.UNICODE.charset());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" [length=").append(this.length);
        sb.append(", changeType=").append((Object)this.changeType);
        sb.append(", newValue=").append(this.getNewValueString());
        sb.append(']');
        return sb.toString();
    }

    public static enum EnvChangeType {
        Database(1){

            @Override
            public int toByteLength(byte dataLength) {
                return super.toByteLength(dataLength) * 2;
            }
        }
        ,
        Language(2){

            @Override
            public int toByteLength(byte dataLength) {
                return super.toByteLength(dataLength) * 2;
            }
        }
        ,
        Charset(3){

            @Override
            public int toByteLength(byte dataLength) {
                return super.toByteLength(dataLength) * 2;
            }
        }
        ,
        Packetsize(4){

            @Override
            public int toByteLength(byte dataLength) {
                return super.toByteLength(dataLength) * 2;
            }
        }
        ,
        UnicodeLCID(5){

            @Override
            public int toByteLength(byte dataLength) {
                return super.toByteLength(dataLength) * 2;
            }
        }
        ,
        UnicodeSortingComparison(6){

            @Override
            public int toByteLength(byte dataLength) {
                return super.toByteLength(dataLength) * 2;
            }
        }
        ,
        SQLCollation(7),
        BeginTx(8),
        CommitTx(9),
        RollbackTx(10),
        EnlistDTC(11),
        DefectTx(12),
        RealtimeLogShipping(13){

            @Override
            public int toByteLength(byte dataLength) {
                return super.toByteLength(dataLength) * 2;
            }
        }
        ,
        PromoteTx(15),
        TXMgrAddress(16),
        TxEnd(17),
        RSETACK(18),
        UserInstance(19){

            @Override
            public int toByteLength(byte dataLength) {
                return super.toByteLength(dataLength) * 2;
            }
        }
        ,
        Routing(20);

        private final byte type;

        private EnvChangeType(int type) {
            this.type = (byte)type;
        }

        public byte getType() {
            return this.type;
        }

        public static EnvChangeType valueOf(int value) {
            for (EnvChangeType envChangeType : EnvChangeType.values()) {
                if (envChangeType.getType() != (byte)value) continue;
                return envChangeType;
            }
            throw new IllegalArgumentException(String.format("Invalid env change type 0x%01X", value));
        }

        public int toByteLength(byte dataLength) {
            return dataLength;
        }
    }
}

