/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.tds;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.message.header.Header;
import io.r2dbc.mssql.message.header.PacketIdProvider;
import io.r2dbc.mssql.message.tds.TdsFragment;
import io.r2dbc.mssql.util.Assert;

public final class TdsPacket
extends TdsFragment {
    private final Header header;

    TdsPacket(Header header, ByteBuf buffer) {
        super(buffer);
        this.header = Assert.requireNonNull(header, "Header must not be null!");
        int expectedBodySize = header.getLength() - 8;
        Assert.isTrue(buffer.readableBytes() == expectedBodySize, () -> String.format("ByteBuffer body size does not match length field in header. Expected body size [%d], actual size [%d]", buffer.readableBytes(), expectedBodySize));
    }

    public ByteBuf encode(ByteBufAllocator allocator) {
        Assert.requireNonNull(allocator, "ByteBufAllocator must not be null");
        ByteBuf buffer = allocator.buffer((int)this.header.getLength());
        this.header.encode(buffer);
        buffer.writeBytes(this.getByteBuf());
        this.getByteBuf().release();
        return buffer;
    }

    public ByteBuf encode(ByteBufAllocator allocator, PacketIdProvider packetIdProvider) {
        Assert.requireNonNull(allocator, "ByteBufAllocator must not be null");
        Assert.requireNonNull(packetIdProvider, "PacketIdProvider must not be null");
        ByteBuf buffer = allocator.buffer((int)this.header.getLength());
        this.header.encode(buffer, packetIdProvider);
        buffer.writeBytes(this.getByteBuf());
        this.getByteBuf().release();
        return buffer;
    }
}

