/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.tds;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.r2dbc.mssql.message.tds.ServerCharset;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public final class Encode {
    public static final int U_SHORT_MAX_VALUE = Math.abs(Short.MIN_VALUE) + Short.MAX_VALUE;

    private Encode() {
    }

    public static void asByte(ByteBuf buffer, int value) {
        buffer.writeByte(value);
    }

    public static void asByte(ByteBuf buffer, byte value) {
        buffer.writeByte((int)value);
    }

    public static void asFloat(ByteBuf buffer, float value) {
        buffer.writeIntLE(Float.floatToIntBits(value));
    }

    public static void asDouble(ByteBuf buffer, double value) {
        buffer.writeLongLE(Double.doubleToLongBits(value));
    }

    public static void dword(ByteBuf buffer, int value) {
        buffer.writeIntLE(value);
    }

    public static void asLong(ByteBuf buffer, int value) {
        buffer.writeIntLE(value);
    }

    public static void smallMoney(ByteBuf buffer, BigInteger value) {
        buffer.writeIntLE(value.intValue());
    }

    public static void money(ByteBuf buffer, BigInteger value) {
        int intBitsHi = (int)(value.longValue() >> 32 & 0xFFFFFFFFL);
        int intBitsLo = (int)(value.longValue() & 0xFFFFFFFFL);
        buffer.writeIntLE(intBitsHi);
        buffer.writeIntLE(intBitsLo);
    }

    public static void bit(ByteBuf buffer, boolean value) {
        Encode.asByte(buffer, (byte)(value ? 1 : 0));
    }

    public static void tinyInt(ByteBuf buffer, byte value) {
        Encode.asByte(buffer, value);
    }

    public static void smallInt(ByteBuf buffer, short value) {
        buffer.writeShortLE((int)value);
    }

    public static void smallInt(ByteBuf buffer, int value) {
        buffer.writeShortLE(value);
    }

    public static void asInt(ByteBuf buffer, int value) {
        buffer.writeIntLE(value);
    }

    public static void bigint(ByteBuf buffer, long value) {
        buffer.writeLongLE(value);
    }

    public static void uLongLong(ByteBuf buffer, long value) {
        buffer.writeLongLE(value);
    }

    public static void uShort(ByteBuf buffer, int value) {
        if (value > U_SHORT_MAX_VALUE) {
            throw new IllegalArgumentException("Value " + value + " exceeds uShort.MAX_VALUE");
        }
        buffer.writeShortLE(value);
    }

    public static void intBigEndian(ByteBuf buffer, int value) {
        buffer.writeInt(value);
    }

    public static void shortBE(ByteBuf buffer, short value) {
        buffer.writeShort((int)value);
    }

    public static void uShortBE(ByteBuf buffer, int value) {
        if (value > U_SHORT_MAX_VALUE) {
            throw new IllegalArgumentException("Value " + value + " exceeds uShort.MAX_VALUE");
        }
        buffer.writeShort(value);
    }

    public static void uString(ByteBuf buffer, String value, Charset charset) {
        ByteBuf encoded = ByteBufUtil.encodeString((ByteBufAllocator)buffer.alloc(), (CharBuffer)CharBuffer.wrap(value), (Charset)charset);
        Encode.uShort(buffer, encoded.readableBytes());
        buffer.writeBytes(encoded);
        encoded.release();
    }

    public static void unicodeStream(ByteBuf buffer, String value) {
        ByteBuf encoded = ByteBufUtil.encodeString((ByteBufAllocator)buffer.alloc(), (CharBuffer)CharBuffer.wrap(value), (Charset)ServerCharset.UNICODE.charset());
        buffer.writeBytes(encoded);
        encoded.release();
    }

    public static void rpcString(ByteBuf buffer, CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            buffer.writeByte((int)((byte)(ch & 0xFF)));
            buffer.writeByte((int)((byte)(ch >> 8 & 0xFF)));
        }
    }

    public static void rpcString(ByteBuf buffer, CharSequence value, Charset charset) {
        buffer.writeCharSequence(value, charset);
    }
}

