/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.header;

public enum Type {
    SQL_BATCH(1),
    PRE_TDS7_LOGIN(2),
    RPC(3),
    TABULAR_RESULT(4),
    ATTENTION(6),
    BULK_LOAD_DATA(7),
    FED_AUTH_TOKEN(8),
    TX_MGR(14),
    TDS7_LOGIN(16),
    SSPI(17),
    PRE_LOGIN(18);

    private final byte value;

    private Type(int value) {
        this.value = Integer.valueOf(value).byteValue();
    }

    public static Type valueOf(byte value) {
        switch (value) {
            case 1: {
                return SQL_BATCH;
            }
            case 2: {
                return PRE_TDS7_LOGIN;
            }
            case 3: {
                return RPC;
            }
            case 4: {
                return TABULAR_RESULT;
            }
            case 6: {
                return ATTENTION;
            }
            case 7: {
                return BULK_LOAD_DATA;
            }
            case 8: {
                return FED_AUTH_TOKEN;
            }
            case 14: {
                return TX_MGR;
            }
            case 16: {
                return TDS7_LOGIN;
            }
            case 17: {
                return SSPI;
            }
            case 18: {
                return PRE_LOGIN;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid header type: 0x%01X", value));
    }

    public byte getValue() {
        return this.value;
    }
}

