/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TypeInformation;
import java.math.BigDecimal;
import java.math.BigInteger;

final class MoneyCodec
extends AbstractCodec<BigDecimal> {
    static final MoneyCodec INSTANCE = new MoneyCodec();
    private static final int BIG_MONEY_LENGTH = 8;
    private static final int SMALL_MONEY_LENGTH = 4;
    private static final byte[] NULL = ByteArray.fromEncoded(alloc -> RpcEncoding.encodeNull(alloc, SqlServerType.MONEY));

    private MoneyCodec() {
        super(BigDecimal.class);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, BigDecimal value) {
        return RpcEncoding.encodeFixed(allocator, SqlServerType.MONEY, value, (buffer, bigDecimal) -> Encode.money(buffer, bigDecimal.unscaledValue()));
    }

    @Override
    public boolean canEncodeNull(SqlServerType serverType) {
        return serverType == SqlServerType.MONEY || serverType == SqlServerType.SMALLMONEY;
    }

    @Override
    public Encoded doEncodeNull(ByteBufAllocator allocator) {
        return RpcEncoding.wrap(NULL, SqlServerType.MONEY);
    }

    @Override
    public Encoded encodeNull(ByteBufAllocator allocator, SqlServerType serverType) {
        return RpcEncoding.encodeNull(allocator, serverType);
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return typeInformation.getServerType() == SqlServerType.MONEY;
    }

    @Override
    BigDecimal doDecode(ByteBuf buffer, Length length, TypeInformation type, Class<? extends BigDecimal> valueType) {
        BigInteger decoded = MoneyCodec.decode(buffer, length.getLength());
        return new BigDecimal(decoded, 4);
    }

    private static BigInteger decode(ByteBuf buffer, int length) {
        switch (length) {
            case 8: {
                int intBitsHi = Decode.asInt(buffer);
                int intBitsLo = Decode.asInt(buffer);
                return BigInteger.valueOf((long)intBitsHi << 32 | (long)intBitsLo & 0xFFFFFFFFL);
            }
            case 4: {
                return BigInteger.valueOf(Decode.asInt(buffer));
            }
        }
        throw ProtocolException.invalidTds(String.format("Unexpected value length: %d", length));
    }
}

