/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.api;

import io.r2dbc.mssql.api.MssqlTransactionDefinition;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Option;
import io.r2dbc.spi.TransactionDefinition;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class SimpleTransactionDefinition
implements MssqlTransactionDefinition {
    public static final SimpleTransactionDefinition EMPTY = new SimpleTransactionDefinition(Collections.emptyMap());
    private final Map<Option<?>, Object> options;

    SimpleTransactionDefinition(Map<Option<?>, Object> options) {
        this.options = options;
    }

    public <T> T getAttribute(Option<T> option) {
        return (T)this.options.get(option);
    }

    public MssqlTransactionDefinition with(Option<?> option, Object value) {
        HashMap options = new HashMap(this.options);
        options.put(Assert.requireNonNull(option, "option must not be null"), Assert.requireNonNull(value, "value must not be null"));
        return new SimpleTransactionDefinition(options);
    }

    @Override
    public MssqlTransactionDefinition isolationLevel(IsolationLevel isolationLevel) {
        return this.with(MssqlTransactionDefinition.ISOLATION_LEVEL, isolationLevel);
    }

    @Override
    public MssqlTransactionDefinition lockTimeout(Duration timeout) {
        return this.with(MssqlTransactionDefinition.LOCK_WAIT_TIMEOUT, timeout);
    }

    @Override
    public MssqlTransactionDefinition name(String name) {
        return this.with(MssqlTransactionDefinition.NAME, name);
    }

    @Override
    public MssqlTransactionDefinition mark(String mark) {
        if (this.getAttribute(TransactionDefinition.NAME) == null) {
            this.name(mark);
        }
        return this.with(MARK, mark);
    }
}

