/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.ConnectionOptions;
import io.r2dbc.mssql.DefaultMssqlResult;
import io.r2dbc.mssql.GeneratedValues;
import io.r2dbc.mssql.MssqlResult;
import io.r2dbc.mssql.MssqlStatement;
import io.r2dbc.mssql.MssqlStatementSupport;
import io.r2dbc.mssql.QueryMessageFlow;
import io.r2dbc.mssql.RpcQueryMessageFlow;
import io.r2dbc.mssql.client.Client;
import io.r2dbc.mssql.client.ConnectionContext;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.token.AbstractDoneToken;
import io.r2dbc.mssql.message.token.DoneInProcToken;
import io.r2dbc.mssql.util.Assert;
import java.util.Locale;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.util.Logger;
import reactor.util.Loggers;

final class SimpleMssqlStatement
extends MssqlStatementSupport
implements MssqlStatement {
    private static final Logger logger = Loggers.getLogger(SimpleMssqlStatement.class);
    private final Client client;
    private final Codecs codecs;
    private final ConnectionOptions connectionOptions;
    private final ConnectionContext context;
    private final String sql;

    SimpleMssqlStatement(Client client, ConnectionOptions connectionOptions, String sql) {
        super(connectionOptions.prefersCursors(sql) || SimpleMssqlStatement.prefersCursors(sql));
        this.connectionOptions = connectionOptions;
        Assert.requireNonNull(client, "Client must not be null");
        Assert.requireNonNull(connectionOptions, "ConnectionOptions must not be null");
        Assert.requireNonNull(sql, "SQL must not be null");
        Assert.isTrue(sql.trim().length() > 0, "SQL must contain text");
        this.client = client;
        this.context = client.getContext();
        this.codecs = connectionOptions.getCodecs();
        this.sql = sql;
    }

    @Override
    public SimpleMssqlStatement add() {
        return this;
    }

    @Override
    public SimpleMssqlStatement bind(String identifier, Object value) {
        throw new UnsupportedOperationException(String.format("Binding parameters is not supported for the statement [%s]", this.sql));
    }

    @Override
    public SimpleMssqlStatement bind(int index, Object value) {
        throw new UnsupportedOperationException(String.format("Binding parameters is not supported for the statement [%s]", this.sql));
    }

    @Override
    public SimpleMssqlStatement bindNull(String identifier, Class<?> type) {
        throw new UnsupportedOperationException(String.format("Binding parameters is not supported for the statement [%s]", this.sql));
    }

    @Override
    public SimpleMssqlStatement bindNull(int index, Class<?> type) {
        throw new UnsupportedOperationException(String.format("Binding parameters is not supported for the statement [%s]", this.sql));
    }

    @Override
    public Flux<MssqlResult> execute() {
        int effectiveFetchSize = this.getEffectiveFetchSize();
        return Flux.defer(() -> {
            String sql;
            boolean useGeneratedKeysClause = GeneratedValues.shouldExpectGeneratedKeys(this.getGeneratedColumns());
            String string = sql = useGeneratedKeysClause ? GeneratedValues.augmentQuery(this.sql, this.getGeneratedColumns()) : this.sql;
            if (effectiveFetchSize > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.context.getMessage("Start cursored exchange for {} with fetch size {}"), new Object[]{sql, effectiveFetchSize});
                }
                Flux<Message> exchange = this.potentiallyAttachTimeout(RpcQueryMessageFlow.exchange(this.client, this.codecs, this.sql, effectiveFetchSize), this.connectionOptions, this.client, this.sql);
                return this.createResultStream(useGeneratedKeysClause, exchange, DoneInProcToken.class::isInstance);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(this.context.getMessage("Start direct exchange for {}"), new Object[]{sql});
            }
            Flux<Message> exchange = this.potentiallyAttachTimeout(QueryMessageFlow.exchange(this.client, sql), this.connectionOptions, this.client, this.sql);
            return this.createResultStream(useGeneratedKeysClause, exchange, AbstractDoneToken.class::isInstance);
        });
    }

    private Publisher<MssqlResult> createResultStream(boolean useGeneratedKeysClause, Flux<Message> exchange, Predicate<Message> windowUntil) {
        if (useGeneratedKeysClause) {
            exchange = exchange.transform(GeneratedValues::reduceToSingleCountDoneToken);
        }
        return exchange.windowUntil(windowUntil).map(it -> DefaultMssqlResult.toResult(this.sql, this.context, this.codecs, (Flux<Message>)it, false));
    }

    @Override
    public SimpleMssqlStatement returnGeneratedValues(String ... columns) {
        super.returnGeneratedValues(columns);
        return this;
    }

    @Override
    public SimpleMssqlStatement fetchSize(int fetchSize) {
        super.fetchSize(fetchSize);
        return this;
    }

    static boolean prefersCursors(String sql) {
        if (sql.isEmpty()) {
            return false;
        }
        String lc = sql.trim().toLowerCase(Locale.ENGLISH);
        if (lc.contains("for xml") || lc.contains("for json")) {
            return false;
        }
        char c = sql.charAt(0);
        return (c == 's' || c == 'S') && lc.startsWith("select");
    }
}

