/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.r2dbc.mssql.MssqlReturnValuesMetadata;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.message.token.ReturnValue;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.OutParameters;
import java.util.List;
import reactor.util.annotation.Nullable;

final class MssqlReturnValues
implements OutParameters,
Message {
    private static final int STATE_ACTIVE = 0;
    private static final int STATE_RELEASED = 1;
    private final Codecs codecs;
    private final MssqlReturnValuesMetadata metadata;
    private final List<ReturnValue> returnValues;
    private volatile int state = 0;

    private MssqlReturnValues(Codecs codecs, List<ReturnValue> returnValues, MssqlReturnValuesMetadata metadata) {
        this.codecs = codecs;
        this.metadata = metadata;
        this.returnValues = returnValues;
    }

    static MssqlReturnValues toReturnValues(Codecs codecs, List<ReturnValue> returnValues) {
        Assert.requireNonNull(codecs, "Codecs must not be null");
        Assert.requireNonNull(returnValues, "ReturnValues must not be null");
        return new MssqlReturnValues(codecs, returnValues, new MssqlReturnValuesMetadata(codecs, returnValues.toArray(new ReturnValue[0])));
    }

    public MssqlReturnValuesMetadata getMetadata() {
        return this.metadata;
    }

    public <T> T get(int index, Class<T> type) {
        Assert.requireNonNull(type, "Type must not be null");
        this.requireNotReleased();
        ReturnValue returnValue = (ReturnValue)this.metadata.get(index);
        return this.doGet(returnValue, type);
    }

    public <T> T get(String name, Class<T> type) {
        Assert.requireNonNull(name, "Name must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        this.requireNotReleased();
        ReturnValue returnValue = (ReturnValue)this.metadata.get(name);
        return this.doGet(returnValue, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T doGet(@Nullable ReturnValue returnValue, Class<T> type) {
        if (returnValue == null) {
            return null;
        }
        if (returnValue.getValueType().getServerType() == SqlServerType.SQL_VARIANT) {
            throw new UnsupportedOperationException("sql_variant columns not supported. See https://github.com/r2dbc/r2dbc-mssql/issues/67.");
        }
        ByteBuf value = returnValue.getValue();
        value.markReaderIndex();
        try {
            T t = this.codecs.decode(value, returnValue.asDecodable(), type);
            return t;
        }
        finally {
            value.resetReaderIndex();
        }
    }

    public void release() {
        this.requireNotReleased();
        this.state = 1;
        this.returnValues.forEach(AbstractReferenceCounted::release);
    }

    private void requireNotReleased() {
        if (this.state == 1) {
            throw new IllegalStateException("Value cannot be retrieved after row has been released");
        }
    }
}

