/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.serialization;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.server.core.EncodedMediaType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.serialization.EntityWriter;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;

public class DynamicEntityWriter
implements EntityWriter {
    private static final MessageBodyWriter<?>[] EMPTY_ARRAY = new MessageBodyWriter[0];
    private final ServerSerialisers serialisers;

    public DynamicEntityWriter(ServerSerialisers serialisers) {
        this.serialisers = serialisers;
    }

    @Override
    public void write(ResteasyReactiveRequestContext context, Object entity) throws IOException {
        EncodedMediaType producesMediaType = context.getResponseContentType();
        MessageBodyWriter<?>[] writers = null;
        MediaType serverSerializersMediaType = null;
        if (producesMediaType == null) {
            ServerSerialisers.BestMatchingServerWriterResult bestMatchingServerWriterResult;
            MediaType selectedMediaType = null;
            boolean mediaTypeComesFromClient = false;
            ServerHttpRequest vertxRequest = context.serverRequest();
            if (context.getTarget() != null && context.getTarget().getProduces() != null) {
                List writersList;
                String accept;
                ServerMediaType producesServerMediaType = context.getTarget().getProduces();
                MediaType negotiatedMediaType = null;
                List<String> accepts = context.getHttpHeaders().getRequestHeader("Accept");
                Iterator<String> iterator = accepts.iterator();
                while (iterator.hasNext() && (negotiatedMediaType = (MediaType)producesServerMediaType.negotiateProduces(accept = iterator.next()).getKey()) == null) {
                }
                if (negotiatedMediaType == null) {
                    negotiatedMediaType = (MediaType)producesServerMediaType.negotiateProduces(vertxRequest.getRequestHeader("Accept")).getKey();
                }
                if (!(writersList = this.serialisers.findWriters(null, entity.getClass(), negotiatedMediaType, RuntimeType.SERVER)).isEmpty()) {
                    MediaType[] sortedOriginalMediaTypes;
                    writers = writersList.toArray(EMPTY_ARRAY);
                    for (MediaType methodMediaType : sortedOriginalMediaTypes = producesServerMediaType.getSortedOriginalMediaTypes()) {
                        if (!methodMediaType.isCompatible(negotiatedMediaType)) continue;
                        selectedMediaType = methodMediaType;
                        break;
                    }
                    if (selectedMediaType == null) {
                        selectedMediaType = sortedOriginalMediaTypes[0];
                    }
                }
            } else if (vertxRequest.getRequestHeader("Accept") != null && !"*/*".equals(vertxRequest.getRequestHeader("Accept")) && !(bestMatchingServerWriterResult = this.serialisers.findBestMatchingServerWriter(null, entity.getClass(), vertxRequest)).isEmpty()) {
                selectedMediaType = bestMatchingServerWriterResult.getSelectedMediaType();
                mediaTypeComesFromClient = true;
                writers = bestMatchingServerWriterResult.getMessageBodyWriters().toArray(ServerSerialisers.NO_WRITER);
            }
            if (writers == null) {
                ServerSerialisers.NoMediaTypeResult writerNoMediaType = this.serialisers.findWriterNoMediaType(context, entity, this.serialisers, RuntimeType.SERVER);
                writers = writerNoMediaType.getWriters();
                selectedMediaType = writerNoMediaType.getMediaType();
            }
            if (selectedMediaType != null) {
                if (MediaTypeHelper.isUnsupportedWildcardSubtype(selectedMediaType) && !mediaTypeComesFromClient) {
                    ServerSerialisers.encodeResponseHeaders(context);
                    ServerHttpResponse httpServerResponse = context.serverResponse();
                    httpServerResponse.setStatusCode(Response.Status.NOT_ACCEPTABLE.getStatusCode());
                    httpServerResponse.end();
                    return;
                }
                serverSerializersMediaType = selectedMediaType;
                context.setResponseContentType(selectedMediaType);
                context.serverResponse().addResponseHeader("Content-Type", context.getResponseContentType().toString());
            }
        } else {
            writers = this.serialisers.findWriters(null, entity.getClass(), producesMediaType.getMediaType(), RuntimeType.SERVER).toArray(ServerSerialisers.NO_WRITER);
        }
        for (MessageBodyWriter<?> w : writers) {
            if (!ServerSerialisers.invokeWriter(context, entity, w, this.serialisers, serverSerializersMediaType)) continue;
            return;
        }
        throw new InternalServerErrorException("Could not find MessageBodyWriter for " + String.valueOf(entity.getClass()), Response.serverError().build());
    }
}

