/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.processor.scanning;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.client.processor.beanparam.BeanParamParser;
import org.jboss.resteasy.reactive.client.processor.beanparam.ClientBeanParamInfo;
import org.jboss.resteasy.reactive.client.processor.beanparam.Item;
import org.jboss.resteasy.reactive.common.model.InjectableBean;
import org.jboss.resteasy.reactive.common.model.MaybeRestClientInterface;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.model.RestClientInterface;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaderWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.IndexedParameter;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonArrayHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonObjectHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonStructureHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonValueHandler;

public class ClientEndpointIndexer
extends EndpointIndexer<ClientEndpointIndexer, ClientIndexedParam, ResourceMethod> {
    static final DotName CONTINUATION = DotName.createSimple((String)"kotlin.coroutines.Continuation");
    static final DotName CLIENT_EXCEPTION_MAPPER = DotName.createSimple((String)"io.quarkus.rest.client.reactive.ClientExceptionMapper");
    private final String[] defaultProduces;
    private final String[] defaultProducesNegotiated;
    private final boolean smartDefaultProduces;

    public ClientEndpointIndexer(AbstractBuilder builder, String defaultProduces, boolean smartDefaultProduces) {
        super((EndpointIndexer.Builder)builder);
        this.defaultProduces = new String[]{defaultProduces};
        this.defaultProducesNegotiated = new String[]{defaultProduces, "*/*"};
        this.smartDefaultProduces = smartDefaultProduces;
    }

    public MaybeRestClientInterface createClientProxy(ClassInfo classInfo, String path) {
        try {
            RestClientInterface clazz = new RestClientInterface();
            clazz.setClassName(classInfo.name().toString());
            clazz.setEncoded(classInfo.hasDeclaredAnnotation(ResteasyReactiveDotNames.ENCODED));
            if (path != null) {
                clazz.setPath(path);
            }
            List methods = this.createEndpoints(classInfo, classInfo, new HashSet(), new HashSet(), clazz.getPathParameters(), clazz.getPath(), false);
            clazz.getMethods().addAll(methods);
            this.warnForUnsupportedAnnotations(classInfo);
            return MaybeRestClientInterface.success((RestClientInterface)clazz);
        }
        catch (Exception e) {
            log.warn((Object)("Ignoring interface for creating client proxy" + String.valueOf(classInfo.name())), (Throwable)e);
            return MaybeRestClientInterface.failure((String)e.getMessage());
        }
    }

    private void warnForUnsupportedAnnotations(ClassInfo classInfo) {
        ArrayList<AnnotationInstance> offendingBlockingAnnotations = new ArrayList<AnnotationInstance>();
        List blockingAnnotations = (List)classInfo.annotationsMap().get(ResteasyReactiveDotNames.BLOCKING);
        if (blockingAnnotations != null) {
            for (AnnotationInstance blockingAnnotation : blockingAnnotations) {
                if (blockingAnnotation.target().annotation(CLIENT_EXCEPTION_MAPPER) != null) continue;
                offendingBlockingAnnotations.add(blockingAnnotation);
            }
        }
        if (!offendingBlockingAnnotations.isEmpty() || classInfo.annotationsMap().get(ResteasyReactiveDotNames.NON_BLOCKING) != null) {
            log.warn((Object)("'@Blocking' and '@NonBlocking' annotations are not necessary (or supported) on REST Client interfaces. Offending class is '" + String.valueOf(classInfo.name()) + "'. Whether or not the call blocks the calling thread depends on the return type of the method - returning 'Uni', 'Multi' or 'CompletionStage' results in the implementation being non-blocking."));
        }
    }

    protected void handleClientSubResource(ResourceMethod resourceMethod, MethodInfo method, IndexView index) {
        ClassInfo subResourceClass = index.getClassByName(method.returnType().name());
        if (subResourceClass == null) {
            throw new IllegalStateException("Subresource method returns an invalid type: " + String.valueOf(method.returnType().name()));
        }
        List endpoints = this.createEndpoints(subResourceClass, subResourceClass, new HashSet(), new HashSet(), new HashSet(), "", false);
        resourceMethod.setSubResourceMethods(endpoints);
    }

    protected ResourceMethod createResourceMethod(MethodInfo info, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
        return new ResourceMethod();
    }

    protected boolean handleBeanParam(ClassInfo actualEndpointInfo, Type paramType, MethodParameter[] methodParameters, int i, Set<String> fileFormNames) {
        ClassInfo beanParamClassInfo = this.index.getClassByName(paramType.name());
        if (methodParameters[i] != null) {
            List<Item> items = BeanParamParser.parse(beanParamClassInfo, this.index);
            ClientBeanParamInfo clientBeanParamInfo = new ClientBeanParamInfo(items, beanParamClassInfo.name().toString());
            clientBeanParamInfo.setDeclaredType(methodParameters[i].getDeclaredType());
            methodParameters[i] = clientBeanParamInfo;
        } else {
            methodParameters[i] = this.parseClientBeanParam(beanParamClassInfo, this.index);
        }
        return false;
    }

    private MethodParameter parseClientBeanParam(ClassInfo beanParamClassInfo, IndexView index) {
        List<Item> items = BeanParamParser.parse(beanParamClassInfo, index);
        return new ClientBeanParamInfo(items, beanParamClassInfo.name().toString());
    }

    protected InjectableBean scanInjectableBean(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, Map<String, String> existingConverters, AdditionalReaders additionalReaders, Map<String, InjectableBean> injectableBeans, boolean hasRuntimeConverters) {
        throw new RuntimeException("Injectable beans not supported in client");
    }

    protected MethodParameter createMethodParameter(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, boolean encoded, Type paramType, ClientIndexedParam parameterResult, String name, String defaultValue, ParameterType type, String elementType, boolean single, String signature, Set<String> fileFormNames) {
        EndpointIndexer.DeclaredTypes declaredTypes = this.getDeclaredTypes(paramType, currentClassInfo, actualEndpointInfo);
        String mimePart = this.getPartMime(parameterResult.getAnns());
        String partFileName = this.getPartFileName(parameterResult.getAnns());
        return new MethodParameter(name, elementType, declaredTypes.getDeclaredType(), declaredTypes.getDeclaredUnresolvedType(), signature, type, single, defaultValue, parameterResult.isObtainedAsCollection(), parameterResult.isOptional(), encoded, mimePart, partFileName, null);
    }

    private String getPartFileName(Map<DotName, AnnotationInstance> annotations) {
        AnnotationInstance partFileName = annotations.get(ResteasyReactiveDotNames.PART_FILE_NAME);
        if (partFileName != null && partFileName.value() != null) {
            return partFileName.value().asString();
        }
        return null;
    }

    protected boolean handleCustomParameter(Map<DotName, AnnotationInstance> anns, ClientIndexedParam builder, Type paramType, boolean field, Map<String, Object> methodContext) {
        if (paramType.name().equals((Object)CONTINUATION)) {
            builder.setType(ParameterType.CUSTOM);
            return true;
        }
        return false;
    }

    protected String[] applyAdditionalDefaults(Type nonAsyncReturnType) {
        if (this.smartDefaultProduces) {
            return super.applyAdditionalDefaults(nonAsyncReturnType);
        }
        if (this.config.isSingleDefaultProduces()) {
            return this.defaultProduces;
        }
        return this.defaultProducesNegotiated;
    }

    protected void addWriterForType(AdditionalWriters additionalWriters, Type paramType) {
        this.addReaderWriterForType((AdditionalReaderWriter)additionalWriters, paramType);
    }

    protected void addReaderForType(AdditionalReaders additionalReaders, Type paramType) {
        this.addReaderWriterForType((AdditionalReaderWriter)additionalReaders, paramType);
    }

    private void addReaderWriterForType(AdditionalReaderWriter additionalReaderWriter, Type paramType) {
        DotName dotName = paramType.name();
        if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_NUMBER) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_VALUE) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRING)) {
            additionalReaderWriter.add(JsonValueHandler.class, "application/json", JsonValue.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_ARRAY)) {
            additionalReaderWriter.add(JsonArrayHandler.class, "application/json", JsonArray.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_OBJECT)) {
            additionalReaderWriter.add(JsonObjectHandler.class, "application/json", JsonObject.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRUCTURE)) {
            additionalReaderWriter.add(JsonStructureHandler.class, "application/json", JsonStructure.class);
        }
    }

    protected ClientIndexedParam createIndexedParam() {
        return new ClientIndexedParam();
    }

    public static class ClientIndexedParam
    extends IndexedParameter<ClientIndexedParam> {
    }

    public static abstract class AbstractBuilder<B extends EndpointIndexer.Builder<ClientEndpointIndexer, B, ResourceMethod>>
    extends EndpointIndexer.Builder<ClientEndpointIndexer, B, ResourceMethod> {
        private String defaultProduces = "text/plain";
        private boolean smartDefaultProduces = true;

        public B setDefaultProduces(String defaultProduces) {
            this.defaultProduces = defaultProduces;
            return (B)((Object)this);
        }

        public B setSmartDefaultProduces(boolean smartDefaultProduces) {
            this.smartDefaultProduces = smartDefaultProduces;
            return (B)((Object)this);
        }

        public ClientEndpointIndexer build() {
            return new ClientEndpointIndexer(this, this.defaultProduces, this.smartDefaultProduces);
        }
    }
}

