/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.breakpoints;

import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.debug.agent.evaluations.ConditionalExpressionHelper;
import io.quarkus.qute.debug.agent.frames.RemoteStackFrame;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Source;

public class RemoteBreakpoint
extends Breakpoint {
    private final transient String condition;
    private transient boolean parsed;
    private transient TemplateNode ifNode;

    public RemoteBreakpoint(Source source, int line, String condition) {
        super.setLine(Integer.valueOf(line));
        super.setSource(source);
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCondition(RemoteStackFrame frame) {
        String condition = this.getCondition();
        if (!this.hasCondition()) {
            return true;
        }
        if (!this.parsed) {
            try {
                this.ifNode = ConditionalExpressionHelper.parseCondition(condition);
            }
            catch (Throwable e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.parsed = true;
            }
        }
        return this.ifNode != null && (Boolean)frame.evaluateCondition(this.ifNode, true).toCompletableFuture().getNow(false) != false;
    }

    public boolean hasCondition() {
        return this.condition != null && !this.condition.isBlank();
    }
}

