/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.variables;

import io.quarkus.qute.debug.agent.frames.RemoteStackFrame;
import io.quarkus.qute.debug.agent.resolvers.ValueResolverRegistry;
import io.quarkus.qute.debug.agent.variables.VariableContext;
import io.quarkus.qute.debug.agent.variables.VariablesHelper;
import io.quarkus.qute.debug.agent.variables.VariablesProvider;
import io.quarkus.qute.debug.agent.variables.VariablesRegistry;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.lsp4j.debug.Variable;

public class RemoteVariable
extends Variable
implements VariablesProvider {
    private final transient VariablesRegistry variablesRegistry;
    private transient Collection<Variable> variables;
    private transient Object value;
    private final transient RemoteStackFrame frame;

    public RemoteVariable(Object value, RemoteStackFrame frame, VariablesRegistry variablesRegistry) {
        this.value = value;
        this.variablesRegistry = variablesRegistry;
        this.frame = frame;
        variablesRegistry.addVariable(this);
    }

    @Override
    public Collection<Variable> getVariables() {
        if (this.variables == null) {
            this.variables = new ArrayList<Variable>();
            Object object = this.value;
            if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                iterable.forEach(item -> {
                    int index = this.variables.size();
                    String name = String.valueOf(index);
                    VariablesHelper.fillVariable(name, item, this.frame, this.variables, this.variablesRegistry);
                });
            } else if (this.value != null && this.value.getClass().isArray()) {
                int length = Array.getLength(this.value);
                for (int i = 0; i < length; ++i) {
                    String name = String.valueOf(i);
                    Object item2 = Array.get(this.value, i);
                    VariablesHelper.fillVariable(name, item2, this.frame, this.variables, this.variablesRegistry);
                }
            } else {
                VariableContext context = new VariableContext(this.value, this.frame, this.variablesRegistry, this.variables);
                ValueResolverRegistry.getInstance().fillWithValueResolvers(context);
            }
            return this.variables;
        }
        return Collections.emptyList();
    }
}

