/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.source;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.lsp4j.debug.SourceResponse;

public class SourceReferenceRegistry {
    private static final String QUTE_MIME_TYPE = "text/x-qute";
    private static final AtomicInteger sourceReferenceIdCounter = new AtomicInteger();
    private final Map<Integer, SourceResponse> sourceReferences = new ConcurrentHashMap<Integer, SourceResponse>();

    public SourceResponse getSourceReference(int sourceReference) {
        return this.sourceReferences.get(sourceReference);
    }

    public int registerSourceReference(URI uri) {
        int sourceReference = sourceReferenceIdCounter.incrementAndGet();
        String content = SourceReferenceRegistry.readFromJarUri(uri);
        SourceResponse response = new SourceResponse();
        response.setContent(content);
        response.setMimeType(QUTE_MIME_TYPE);
        this.sourceReferences.put(sourceReference, response);
        return sourceReference;
    }

    public static String readFromJarUri(URI uri) {
        String string;
        block9: {
            if (uri == null) {
                return "";
            }
            URL url = uri.toURL();
            InputStream in = url.openStream();
            try {
                string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return "";
                }
            }
            in.close();
        }
        return string;
    }

    public void reset() {
        this.sourceReferences.clear();
    }
}

