/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.micrometer.core.instrument.Counter;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.ForwardingWebSocketEndpoint;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;

final class MetricsForwardingWebSocketEndpoint
extends ForwardingWebSocketEndpoint {
    private final Counter onMessageReceivedCounter;
    private final Counter onMessageReceivedBytesCounter;
    private final Counter onConnectionClosedCounter;

    MetricsForwardingWebSocketEndpoint(WebSocketEndpoint delegate, Counter onMessageReceivedCounter, Counter onMessageReceivedBytesCounter, Counter onConnectionClosedCounter) {
        super(delegate);
        this.onMessageReceivedCounter = onMessageReceivedCounter;
        this.onMessageReceivedBytesCounter = onMessageReceivedBytesCounter;
        this.onConnectionClosedCounter = onConnectionClosedCounter;
    }

    @Override
    public Future<Void> onTextMessage(Object message) {
        this.addMetricsIfMessageIsString(message);
        return this.delegate.onTextMessage(message);
    }

    @Override
    public Future<Void> onBinaryMessage(Object message) {
        this.addMetricsIfMessageIsBuffer(message);
        return this.delegate.onBinaryMessage(message);
    }

    @Override
    public Object decodeTextMultiItem(Object message) {
        this.addMetricsIfMessageIsString(message);
        return this.delegate.decodeTextMultiItem(message);
    }

    @Override
    public Object decodeBinaryMultiItem(Object message) {
        this.addMetricsIfMessageIsBuffer(message);
        return this.delegate.decodeBinaryMultiItem(message);
    }

    @Override
    public Future<Void> onClose() {
        this.onConnectionClosedCounter.increment();
        return this.delegate.onClose();
    }

    private void addMetricsIfMessageIsString(Object message) {
        if (message instanceof String) {
            String stringMessage = (String)message;
            this.onMessageReceivedCounter.increment();
            double bytesNum = stringMessage.getBytes().length;
            this.onMessageReceivedBytesCounter.increment(bytesNum);
        }
    }

    private void addMetricsIfMessageIsBuffer(Object message) {
        if (message instanceof Buffer) {
            Buffer bufferMessage = (Buffer)message;
            this.onMessageReceivedCounter.increment();
            double bytesNum = bufferMessage.getBytes().length;
            this.onMessageReceivedBytesCounter.increment(bytesNum);
        }
    }
}

