/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.deployment;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.websockets.next.WebSocketException;
import io.quarkus.websockets.next.deployment.CallbackArgument;
import io.quarkus.websockets.next.deployment.WebSocketDotNames;
import io.quarkus.websockets.next.deployment.WebSocketProcessor;
import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

class PathParamCallbackArgument
implements CallbackArgument {
    PathParamCallbackArgument() {
    }

    @Override
    public boolean matches(CallbackArgument.ParameterContext context) {
        String name = this.getParamName(context);
        if (name != null) {
            if (!context.parameter().type().name().equals((Object)WebSocketDotNames.STRING)) {
                throw new WebSocketException("Method parameter annotated with @PathParam must be java.lang.String: " + WebSocketProcessor.methodToString(context.parameter().method()));
            }
            if (context.endpointPath() == null) {
                throw new WebSocketException("Global error handlers may not accept @PathParam parameters: " + WebSocketProcessor.methodToString(context.parameter().method()));
            }
            List<String> pathParams = PathParamCallbackArgument.getPathParamNames(context.endpointPath());
            if (!pathParams.contains(name)) {
                throw new WebSocketException(String.format("@PathParam name [%s] must be used in the endpoint path [%s]: %s", name, context.endpointPath(), WebSocketProcessor.methodToString(context.parameter().method())));
            }
            return true;
        }
        return false;
    }

    @Override
    public Expr get(CallbackArgument.InvocationBytecodeContext context) {
        String paramName = this.getParamName(context);
        return context.bytecode().invokeVirtual(MethodDesc.of(WebSocketConnectionBase.class, (String)"pathParam", String.class, (Class[])new Class[]{String.class}), (Expr)context.getConnection(), (Expr)Const.of((String)paramName));
    }

    private String getParamName(CallbackArgument.ParameterContext context) {
        AnnotationInstance pathParamAnnotation = Annotations.find(context.parameterAnnotations(), (DotName)WebSocketDotNames.PATH_PARAM);
        if (pathParamAnnotation != null) {
            AnnotationValue nameVal = pathParamAnnotation.value();
            String name = nameVal != null ? nameVal.asString() : context.parameter().name();
            if (name == null) {
                throw new WebSocketException(String.format("Unable to extract the path parameter name - method parameter names not recorded for %s: compile the class with -parameters", context.parameter().method().declaringClass().name()));
            }
            return name;
        }
        return null;
    }

    static List<String> getPathParamNames(String path) {
        ArrayList<String> names = new ArrayList<String>();
        Matcher m = WebSocketProcessor.TRANSLATED_PATH_PARAM_PATTERN.matcher(path);
        while (m.find()) {
            names.add(m.group().substring(1));
        }
        return names;
    }
}

