/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.InvokerFactoryBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.arc.processor.KotlinDotNames;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.arc.processor.RuntimeTypeCreator;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.GeneratedClassGizmo2Adaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsAllowedBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.creator.InstanceMethodCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.spi.ClassSecurityAnnotationBuildItem;
import io.quarkus.security.spi.ClassSecurityCheckStorageBuildItem;
import io.quarkus.security.spi.PermissionsAllowedMetaAnnotationBuildItem;
import io.quarkus.security.spi.SecurityTransformer;
import io.quarkus.security.spi.SecurityTransformerBuildItem;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.vertx.http.deployment.EagerSecurityInterceptorClassesBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.quarkus.websockets.next.HttpUpgradeCheck;
import io.quarkus.websockets.next.InboundProcessingMode;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.quarkus.websockets.next.WebSocketClientException;
import io.quarkus.websockets.next.WebSocketConnection;
import io.quarkus.websockets.next.WebSocketException;
import io.quarkus.websockets.next.WebSocketSecurity;
import io.quarkus.websockets.next.WebSocketServerException;
import io.quarkus.websockets.next.deployment.Callback;
import io.quarkus.websockets.next.deployment.CallbackArgument;
import io.quarkus.websockets.next.deployment.CallbackArgumentBuildItem;
import io.quarkus.websockets.next.deployment.CallbackArgumentsBuildItem;
import io.quarkus.websockets.next.deployment.CloseReasonCallbackArgument;
import io.quarkus.websockets.next.deployment.ConnectionCallbackArgument;
import io.quarkus.websockets.next.deployment.ErrorCallbackArgument;
import io.quarkus.websockets.next.deployment.GeneratedEndpointBuildItem;
import io.quarkus.websockets.next.deployment.GlobalErrorHandlersBuildItem;
import io.quarkus.websockets.next.deployment.HandshakeRequestCallbackArgument;
import io.quarkus.websockets.next.deployment.KotlinContinuationCallbackArgument;
import io.quarkus.websockets.next.deployment.MessageCallbackArgument;
import io.quarkus.websockets.next.deployment.PathParamCallbackArgument;
import io.quarkus.websockets.next.deployment.WebSocketDotNames;
import io.quarkus.websockets.next.deployment.WebSocketEndpointBuildItem;
import io.quarkus.websockets.next.deployment.config.WebSocketsServerBuildConfig;
import io.quarkus.websockets.next.runtime.BasicWebSocketConnectorImpl;
import io.quarkus.websockets.next.runtime.ClientConnectionManager;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.ConnectionManager;
import io.quarkus.websockets.next.runtime.ContextSupport;
import io.quarkus.websockets.next.runtime.HttpUpgradeSecurityInterceptor;
import io.quarkus.websockets.next.runtime.JsonTextMessageCodec;
import io.quarkus.websockets.next.runtime.SecurityHttpUpgradeCheck;
import io.quarkus.websockets.next.runtime.SecuritySupport;
import io.quarkus.websockets.next.runtime.WebSocketClientRecorder;
import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.WebSocketConnectorImpl;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.WebSocketEndpointBase;
import io.quarkus.websockets.next.runtime.WebSocketHeaderPropagationHandler;
import io.quarkus.websockets.next.runtime.WebSocketHttpServerOptionsCustomizer;
import io.quarkus.websockets.next.runtime.WebSocketSecurityIdentityAssociation;
import io.quarkus.websockets.next.runtime.WebSocketServerRecorder;
import io.quarkus.websockets.next.runtime.config.WebSocketsServerRuntimeConfig;
import io.quarkus.websockets.next.runtime.kotlin.ApplicationCoroutineScope;
import io.quarkus.websockets.next.runtime.kotlin.CoroutineInvoker;
import io.quarkus.websockets.next.runtime.telemetry.ErrorInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.MetricsBuilderCustomizer;
import io.quarkus.websockets.next.runtime.telemetry.TracesBuilderCustomizer;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryProvider;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryProviderBuilder;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryRecorder;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniCreate;
import io.smallrye.mutiny.groups.UniOnFailure;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.invoke.Invoker;
import jakarta.inject.Singleton;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.WildcardType;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;

public class WebSocketProcessor {
    static final String SERVER_ENDPOINT_SUFFIX = "_WebSocketServerEndpoint";
    static final String CLIENT_ENDPOINT_SUFFIX = "_WebSocketClientEndpoint";
    static final String NESTED_SEPARATOR = "$_";
    static final DotName HTTP_UPGRADE_CHECK_NAME = DotName.createSimple(HttpUpgradeCheck.class);
    private static final DotName WEBSOCKET_SECURITY_NAME = DotName.createSimple(WebSocketSecurity.class);
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{[a-zA-Z0-9_]+\\}");
    public static final Pattern TRANSLATED_PATH_PARAM_PATTERN = Pattern.compile(":[a-zA-Z0-9_]+");

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("websockets-next");
    }

    @BuildStep
    void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(WebSocketDotNames.WEB_SOCKET, DotNames.SINGLETON));
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(WebSocketDotNames.WEB_SOCKET_CLIENT, DotNames.SINGLETON));
    }

    @BuildStep
    AutoAddScopeBuildItem addScopeToGlobalErrorHandlers() {
        return AutoAddScopeBuildItem.builder().containsAnnotations(new DotName[]{WebSocketDotNames.ON_ERROR}).reason("Add @Singleton to a global WebSocket error handler").defaultScope(BuiltinScope.SINGLETON).build();
    }

    @BuildStep
    ExecutionModelAnnotationsAllowedBuildItem executionModelAnnotations(final TransformedAnnotationsBuildItem transformedAnnotations) {
        return new ExecutionModelAnnotationsAllowedBuildItem((Predicate)new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo method) {
                return Annotations.containsAny((Collection)transformedAnnotations.getAnnotations((AnnotationTarget)method), WebSocketDotNames.CALLBACK_ANNOTATIONS);
            }
        });
    }

    @BuildStep
    CallbackArgumentsBuildItem collectCallbackArguments(List<CallbackArgumentBuildItem> callbackArguments) {
        ArrayList<CallbackArgument> sorted = new ArrayList<CallbackArgument>();
        for (CallbackArgumentBuildItem callbackArgument : callbackArguments) {
            sorted.add(callbackArgument.getProvider());
        }
        sorted.sort(Comparator.comparingInt(CallbackArgument::priority).reversed());
        return new CallbackArgumentsBuildItem(sorted);
    }

    @BuildStep
    void additionalBeans(CombinedIndexBuildItem combinedIndex, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        IndexView index = combinedIndex.getIndex();
        AdditionalBeanBuildItem removable = AdditionalBeanBuildItem.builder().setRemovable().addBeanClasses(new Class[]{WebSocketConnectorImpl.class, JsonTextMessageCodec.class}).build();
        additionalBeans.produce((BuildItem)removable);
        AdditionalBeanBuildItem.Builder unremovable = AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{Codecs.class, ClientConnectionManager.class, BasicWebSocketConnectorImpl.class});
        if (!index.getAnnotations(WebSocketDotNames.WEB_SOCKET).isEmpty()) {
            unremovable.addBeanClasses(new Class[]{ConnectionManager.class, WebSocketHttpServerOptionsCustomizer.class});
        }
        additionalBeans.produce((BuildItem)unremovable.build());
    }

    @BuildStep
    void produceCoroutineScope(BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        if (!QuarkusClassLoader.isClassPresentAtRuntime((String)"kotlinx.coroutines.CoroutineScope")) {
            return;
        }
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(ApplicationCoroutineScope.class).setUnremovable().build());
    }

    @BuildStep
    void builtinCallbackArguments(BuildProducer<CallbackArgumentBuildItem> providers) {
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new MessageCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new ConnectionCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new PathParamCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new HandshakeRequestCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new ErrorCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new CloseReasonCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new KotlinContinuationCallbackArgument()));
    }

    @BuildStep
    void collectGlobalErrorHandlers(BeanArchiveIndexBuildItem beanArchiveIndex, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, BuildProducer<GlobalErrorHandlersBuildItem> globalErrorHandlers, BuildProducer<UnremovableBeanBuildItem> unremovableBean, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations) {
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<DotName, GlobalErrorHandler> globalErrors = new HashMap<DotName, GlobalErrorHandler>();
        HashSet<DotName> unremovableBeanClasses = new HashSet<DotName>();
        for (BeanInfo bean : beanDiscoveryFinished.beanStream().classBeans()) {
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            if (beanClass.declaredAnnotation(WebSocketDotNames.WEB_SOCKET) != null || beanClass.declaredAnnotation(WebSocketDotNames.WEB_SOCKET_CLIENT) != null) continue;
            List<Callback> errorHandlers = WebSocketProcessor.findErrorHandlers(Callback.Target.UNDEFINED, index, bean, beanClass, callbackArguments, transformedAnnotations, null);
            for (Callback callback : errorHandlers) {
                GlobalErrorHandler errorHandler = new GlobalErrorHandler(bean, callback);
                DotName errorTypeName = callback.argumentType(ErrorCallbackArgument::isError).name();
                if (globalErrors.containsKey(errorTypeName)) {
                    throw new WebSocketException(String.format("Multiple global @OnError callbacks may not accept the same error parameter: %s\n\t- %s\n\t- %s", errorTypeName, callback.asString(), ((GlobalErrorHandler)globalErrors.get((Object)errorTypeName)).callback.asString()));
                }
                globalErrors.put(errorTypeName, errorHandler);
            }
            if (errorHandlers.isEmpty()) continue;
            unremovableBeanClasses.add(beanClass.name());
        }
        globalErrorHandlers.produce((BuildItem)new GlobalErrorHandlersBuildItem(List.copyOf(globalErrors.values())));
        unremovableBean.produce((BuildItem)UnremovableBeanBuildItem.beanTypes(unremovableBeanClasses));
    }

    @BuildStep
    void collectEndpoints(BeanArchiveIndexBuildItem beanArchiveIndex, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<WebSocketEndpointBuildItem> endpoints) {
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<String, DotName> serverIdToEndpoint = new HashMap<String, DotName>();
        HashMap<String, DotName> serverPathToEndpoint = new HashMap<String, DotName>();
        HashMap<String, DotName> clientIdToEndpoint = new HashMap<String, DotName>();
        HashMap<String, DotName> clientPathToEndpoint = new HashMap<String, DotName>();
        for (BeanInfo bean : beanDiscoveryFinished.beanStream().classBeans()) {
            Type effectiveMessageType;
            AnnotationValue inboundProcessingMode;
            String id;
            String path;
            Callback.Target target;
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            AnnotationInstance webSocketAnnotation = beanClass.annotation(WebSocketDotNames.WEB_SOCKET);
            AnnotationInstance webSocketClientAnnotation = beanClass.annotation(WebSocketDotNames.WEB_SOCKET_CLIENT);
            if (webSocketAnnotation == null && webSocketClientAnnotation == null) continue;
            if (webSocketAnnotation != null && webSocketClientAnnotation != null) {
                throw new WebSocketException("Endpoint class may not be annotated with both @WebSocket and @WebSocketClient: " + String.valueOf(beanClass));
            }
            if (webSocketAnnotation != null) {
                target = Callback.Target.SERVER;
                path = WebSocketProcessor.getPath(webSocketAnnotation.value("path").asString());
                if (beanClass.nestingType() == ClassInfo.NestingType.INNER) {
                    path = WebSocketProcessor.mergePath(WebSocketProcessor.getPathPrefix(index, beanClass.enclosingClass()), path);
                }
                if ((prevPath = serverPathToEndpoint.put(path, beanClass.name())) != null) {
                    throw new WebSocketServerException(String.format("Multiple endpoints [%s, %s] define the same path: %s", prevPath, beanClass, path));
                }
                AnnotationValue endpointIdValue = webSocketAnnotation.value("endpointId");
                id = endpointIdValue == null ? beanClass.name().toString() : endpointIdValue.asString();
                prevId = serverIdToEndpoint.put(id, beanClass.name());
                if (prevId != null) {
                    throw new WebSocketServerException(String.format("Multiple endpoints [%s, %s] define the same endpoint id: %s", prevId, beanClass, id));
                }
                inboundProcessingMode = webSocketAnnotation.value("inboundProcessingMode");
            } else {
                target = Callback.Target.CLIENT;
                path = WebSocketProcessor.getPath(webSocketClientAnnotation.value("path").asString());
                prevPath = clientPathToEndpoint.put(path, beanClass.name());
                if (prevPath != null) {
                    throw new WebSocketServerException(String.format("Multiple client endpoints [%s, %s] define the same path: %s", prevPath, beanClass, path));
                }
                AnnotationValue clientIdValue = webSocketClientAnnotation.value("clientId");
                id = clientIdValue == null ? beanClass.name().toString() : clientIdValue.asString();
                prevId = clientIdToEndpoint.put(id, beanClass.name());
                if (prevId != null) {
                    throw new WebSocketServerException(String.format("Multiple client endpoints [%s, %s] define the same endpoint id: %s", prevId, beanClass, id));
                }
                inboundProcessingMode = webSocketClientAnnotation.value("inboundProcessingMode");
            }
            Callback onOpen = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_OPEN, callbackArguments, transformedAnnotations, path);
            Callback onTextMessage = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_TEXT_MESSAGE, callbackArguments, transformedAnnotations, path);
            Callback onBinaryMessage = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_BINARY_MESSAGE, callbackArguments, transformedAnnotations, path);
            Callback onPingMessage = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_PING_MESSAGE, callbackArguments, transformedAnnotations, path, this::validateOnPingMessage);
            Callback onPongMessage = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_PONG_MESSAGE, callbackArguments, transformedAnnotations, path, this::validateOnPongMessage);
            Callback onClose = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_CLOSE, callbackArguments, transformedAnnotations, path, this::validateOnClose);
            if (onOpen == null && onTextMessage == null && onBinaryMessage == null && onPingMessage == null && onPongMessage == null) {
                throw new WebSocketServerException("The endpoint must declare at least one method annotated with @OnTextMessage, @OnBinaryMessage, @OnPingMessage, @OnPongMessage or @OnOpen: " + String.valueOf(beanClass));
            }
            if (onTextMessage != null && (effectiveMessageType = onTextMessage.isKotlinSuspendFunction() ? (onTextMessage.isReturnTypeUni() ? (Type)onTextMessage.returnType().asParameterizedType().arguments().get(0) : KotlinUtils.getKotlinSuspendMethodResult((MethodInfo)onTextMessage.method)) : (onTextMessage.isReturnTypeUni() || onTextMessage.isReturnTypeMulti() ? (Type)onTextMessage.returnType().asParameterizedType().arguments().get(0) : onTextMessage.returnType())).kind() != Type.Kind.VOID && onTextMessage.getOutputCodec() == null) {
                reflectiveHierarchy.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((Type)effectiveMessageType).build());
            }
            endpoints.produce((BuildItem)new WebSocketEndpointBuildItem(target == Callback.Target.CLIENT, bean, path, id, inboundProcessingMode != null ? InboundProcessingMode.valueOf((String)inboundProcessingMode.asEnum()) : InboundProcessingMode.SERIAL, onOpen, onTextMessage, onBinaryMessage, onPingMessage, onPongMessage, onClose, WebSocketProcessor.findErrorHandlers(target, index, bean, beanClass, callbackArguments, transformedAnnotations, path)));
        }
    }

    @BuildStep
    void validateConnectorInjectionPoints(List<WebSocketEndpointBuildItem> endpoints, BeanDiscoveryFinishedBuildItem beanDiscoveryFinishedBuildItem, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        for (InjectionPointInfo injectionPoint : validationPhase.getContext().getInjectionPoints()) {
            if (!injectionPoint.getRequiredType().name().equals((Object)WebSocketDotNames.WEB_SOCKET_CONNECTOR) || !injectionPoint.hasDefaultedQualifier()) continue;
            Type clientEndpointType = (Type)injectionPoint.getRequiredType().asParameterizedType().arguments().get(0);
            if (beanDiscoveryFinishedBuildItem.beanStream().withBeanClass(clientEndpointType.name()).isEmpty()) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new WebSocketClientException(String.format("Type argument [%s] of the injected WebSocketConnector is not a @WebSocketClient endpoint, because it is not a bean: %s\nPlease consult https://quarkus.io/guides/cdi-reference#bean_discovery on how to make the module containing the code discoverable by Quarkus. ", clientEndpointType, injectionPoint.getTargetInfo()))}));
                continue;
            }
            if (!endpoints.stream().filter(WebSocketEndpointBuildItem::isClient).map(WebSocketEndpointBuildItem::beanClassName).noneMatch(arg_0 -> ((DotName)clientEndpointType.name()).equals(arg_0))) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new WebSocketClientException(String.format("Type argument [%s] of the injected WebSocketConnector is not a @WebSocketClient endpoint: %s", clientEndpointType, injectionPoint.getTargetInfo()))}));
        }
    }

    @BuildStep
    void generateEndpoints(BeanArchiveIndexBuildItem index, List<WebSocketEndpointBuildItem> endpoints, TransformedAnnotationsBuildItem transformedAnnotations, GlobalErrorHandlersBuildItem globalErrorHandlers, InvokerFactoryBuildItem invokerFactory, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<GeneratedEndpointBuildItem> generatedEndpoints, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        boolean metricsSupportEnabled = WebSocketProcessor.isMetricsSupportEnabled(metricsCapability);
        GeneratedClassGizmo2Adaptor classOutput = new GeneratedClassGizmo2Adaptor(generatedClasses, generatedResources, (Function)new Function<String, String>(){

            @Override
            public String apply(String name) {
                int idx = name.indexOf(WebSocketProcessor.CLIENT_ENDPOINT_SUFFIX);
                if (idx == -1) {
                    idx = name.indexOf(WebSocketProcessor.SERVER_ENDPOINT_SUFFIX);
                }
                if (idx != -1) {
                    name = name.substring(0, idx);
                }
                if (name.contains(WebSocketProcessor.NESTED_SEPARATOR)) {
                    name = name.replace(WebSocketProcessor.NESTED_SEPARATOR, "$");
                }
                return name;
            }
        });
        Gizmo gizmo = Gizmo.create((ClassOutput)classOutput).withDebugInfo(false).withParameters(false);
        for (WebSocketEndpointBuildItem endpoint : endpoints) {
            String generatedName = WebSocketProcessor.generateEndpoint(endpoint, transformedAnnotations, index.getIndex(), gizmo, globalErrorHandlers, endpoint.isClient() ? CLIENT_ENDPOINT_SUFFIX : SERVER_ENDPOINT_SUFFIX, invokerFactory, metricsSupportEnabled);
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{generatedName}).constructors().build());
            generatedEndpoints.produce((BuildItem)new GeneratedEndpointBuildItem(endpoint.id, endpoint.bean.getImplClazz().name().toString(), generatedName, endpoint.path, endpoint.isClient));
        }
    }

    @Consume.List(value={@Consume(value=RuntimeConfigSetupCompleteBuildItem.class), @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void registerRoutes(WebSocketServerRecorder recorder, List<WebSocketEndpointBuildItem> endpoints, List<GeneratedEndpointBuildItem> generatedEndpoints, WebSocketsServerBuildConfig config, ValidationPhaseBuildItem validationPhase, BuildProducer<RouteBuildItem> routes, Optional<PermissionsAllowedMetaAnnotationBuildItem> metaPermissionsAllowed, EndpointSecurityChecksBuildItem endpointSecurityChecks, Capabilities capabilities, CombinedIndexBuildItem indexBuildItem, Optional<SecurityTransformerBuildItem> securityTransformerBuildItem) {
        boolean securityEnabled = capabilities.isPresent("io.quarkus.security");
        SecurityTransformer securityTransformer = securityEnabled ? SecurityTransformerBuildItem.createSecurityTransformer((IndexView)indexBuildItem.getIndex(), securityTransformerBuildItem) : null;
        for (GeneratedEndpointBuildItem endpoint : generatedEndpoints.stream().filter(GeneratedEndpointBuildItem::isServer).toList()) {
            boolean httpUpgradeSecured = endpointSecurityChecks.endpointIdToSecurityCheck.containsKey(endpoint.endpointId) && WebSocketProcessor.identityUpdateNotSupported(indexBuildItem.getIndex());
            RouteBuildItem.Builder builder = RouteBuildItem.builder().route(endpoint.path).displayOnNotFoundPage("WebSocket Endpoint").handlerType(HandlerType.NORMAL).handler(recorder.createEndpointHandler(endpoint.generatedClassName, endpoint.endpointId, this.activateContext(config.activateRequestContext(), BuiltinScope.REQUEST.getInfo(), endpoint.endpointId, endpoints, validationPhase.getBeanResolver(), metaPermissionsAllowed, securityEnabled, httpUpgradeSecured, securityTransformer), this.activateContext(config.activateSessionContext(), new ScopeInfo(DotName.createSimple(SessionScoped.class), true), endpoint.endpointId, endpoints, validationPhase.getBeanResolver(), metaPermissionsAllowed, securityEnabled, httpUpgradeSecured, securityTransformer), endpoint.path));
            routes.produce((BuildItem)builder.build());
        }
    }

    private boolean activateContext(WebSocketsServerBuildConfig.ContextActivation activation, ScopeInfo scope, String endpointId, List<WebSocketEndpointBuildItem> endpoints, BeanResolver beanResolver, Optional<PermissionsAllowedMetaAnnotationBuildItem> metaPermissionsAllowed, boolean securityEnabled, boolean httpUpgradeSecured, SecurityTransformer securityTransformer) {
        return switch (activation) {
            case WebSocketsServerBuildConfig.ContextActivation.ALWAYS -> true;
            case WebSocketsServerBuildConfig.ContextActivation.AUTO -> this.needsContext(this.findEndpoint((String)endpointId, endpoints).bean, scope, new HashSet<String>(), beanResolver, metaPermissionsAllowed, securityEnabled, httpUpgradeSecured, securityTransformer);
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)activation));
        };
    }

    private WebSocketEndpointBuildItem findEndpoint(String endpointId, List<WebSocketEndpointBuildItem> endpoints) {
        for (WebSocketEndpointBuildItem endpoint : endpoints) {
            if (!endpoint.id.equals(endpointId)) continue;
            return endpoint;
        }
        throw new IllegalArgumentException("Endpoint not found: " + endpointId);
    }

    private boolean needsContext(BeanInfo bean, ScopeInfo scope, Set<String> processedBeans, BeanResolver beanResolver, Optional<PermissionsAllowedMetaAnnotationBuildItem> metaPermissionsAllowed, boolean securityEnabled, boolean httpUpgradeSecured, SecurityTransformer securityTransformer) {
        if (processedBeans.add(bean.getIdentifier())) {
            if (scope.equals((Object)bean.getScope())) {
                return true;
            }
            if (securityEnabled && BuiltinScope.REQUEST.is(scope) && bean.isClassBean() && bean.hasAroundInvokeInterceptors() && WebSocketProcessor.hasSecurityAnnNotOnHttpUpgrade(((AnnotationTarget)bean.getTarget().get()).asClass(), metaPermissionsAllowed, httpUpgradeSecured, securityTransformer)) {
                return true;
            }
            for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
                BeanInfo dependency = injectionPoint.getResolvedBean();
                if (dependency != null) {
                    if (!this.needsContext(dependency, scope, processedBeans, beanResolver, metaPermissionsAllowed, securityEnabled, false, securityTransformer)) continue;
                    return true;
                }
                Type requiredType = null;
                HashSet qualifiers = null;
                if (BuiltinBean.INSTANCE.matches(injectionPoint)) {
                    requiredType = injectionPoint.getRequiredType();
                    qualifiers = injectionPoint.getRequiredQualifiers();
                } else if (BuiltinBean.LIST.matches(injectionPoint)) {
                    requiredType = (Type)injectionPoint.getRequiredType().asParameterizedType().arguments().get(0);
                    qualifiers = new HashSet(injectionPoint.getRequiredQualifiers());
                    Iterator it = qualifiers.iterator();
                    while (it.hasNext()) {
                        if (!((AnnotationInstance)it.next()).name().equals((Object)DotNames.ALL)) continue;
                        it.remove();
                    }
                }
                if (requiredType == null) continue;
                for (BeanInfo lookupDependency : beanResolver.resolveBeans(requiredType, (Set)qualifiers)) {
                    if (!this.needsContext(lookupDependency, scope, processedBeans, beanResolver, metaPermissionsAllowed, securityEnabled, false, securityTransformer)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasSecurityAnnNotOnHttpUpgrade(ClassInfo classInfo, Optional<PermissionsAllowedMetaAnnotationBuildItem> metaPermissionsAllowed, boolean httpUpgradeSecured, SecurityTransformer securityTransformer) {
        List annotations;
        if (httpUpgradeSecured) {
            for (MethodInfo method : classInfo.methods()) {
                if (!securityTransformer.hasSecurityAnnotation((AnnotationTarget)method, new SecurityTransformer.AuthorizationType[]{SecurityTransformer.AuthorizationType.SECURITY_CHECK})) continue;
                return true;
            }
            annotations = classInfo.annotations().stream().filter(ai -> ai.target() != null && ai.target().kind() == AnnotationTarget.Kind.METHOD).toList();
        } else {
            if (securityTransformer.hasSecurityAnnotation((AnnotationTarget)classInfo, new SecurityTransformer.AuthorizationType[]{SecurityTransformer.AuthorizationType.SECURITY_CHECK})) {
                return true;
            }
            for (MethodInfo method : classInfo.methods()) {
                if (!securityTransformer.hasSecurityAnnotation((AnnotationTarget)method, new SecurityTransformer.AuthorizationType[]{SecurityTransformer.AuthorizationType.SECURITY_CHECK})) continue;
                return true;
            }
            annotations = classInfo.annotations();
        }
        return metaPermissionsAllowed.get().hasPermissionsAllowed(annotations);
    }

    @BuildStep
    UnremovableBeanBuildItem makeHttpUpgradeChecksUnremovable() {
        return UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{HTTP_UPGRADE_CHECK_NAME});
    }

    @BuildStep
    List<ValidationPhaseBuildItem.ValidationErrorBuildItem> validateHttpUpgradeCheckNotRequestScoped(ValidationPhaseBuildItem validationPhase) {
        return validationPhase.getContext().beans().withBeanType(HTTP_UPGRADE_CHECK_NAME).filter(b -> {
            BuiltinScope targetScope = BuiltinScope.from((DotName)b.getScope().getDotName());
            return BuiltinScope.APPLICATION != targetScope && BuiltinScope.SINGLETON != targetScope && BuiltinScope.DEPENDENT != targetScope;
        }).stream().map(b -> new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new RuntimeException("Bean '%s' scope is '%s', but the '%s' implementors must be one either `@ApplicationScoped', '@Singleton' or '@Dependent' beans".formatted(b.getBeanClass(), b.getScope().getDotName(), HTTP_UPGRADE_CHECK_NAME))})).toList();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void serverSyntheticBeans(WebSocketServerRecorder recorder, List<GeneratedEndpointBuildItem> generatedEndpoints, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        List<GeneratedEndpointBuildItem> serverEndpoints = generatedEndpoints.stream().filter(GeneratedEndpointBuildItem::isServer).toList();
        if (serverEndpoints.isEmpty()) {
            return;
        }
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(WebSocketConnection.class).scope(SessionScoped.class)).setRuntimeInit().supplier(recorder.connectionSupplier()).unremovable()).done());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void clientSyntheticBeans(WebSocketClientRecorder recorder, List<GeneratedEndpointBuildItem> generatedEndpoints, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        List<GeneratedEndpointBuildItem> clientEndpoints = generatedEndpoints.stream().filter(GeneratedEndpointBuildItem::isClient).toList();
        if (!clientEndpoints.isEmpty()) {
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(WebSocketClientConnection.class).scope(SessionScoped.class)).setRuntimeInit().supplier(recorder.connectionSupplier()).unremovable()).done());
        }
        HashMap<String, WebSocketClientRecorder.ClientEndpoint> endpointMap = new HashMap<String, WebSocketClientRecorder.ClientEndpoint>();
        for (GeneratedEndpointBuildItem generatedEndpoint : clientEndpoints) {
            endpointMap.put(generatedEndpoint.endpointClassName, new WebSocketClientRecorder.ClientEndpoint(generatedEndpoint.endpointId, WebSocketProcessor.getOriginalPath(generatedEndpoint.path), generatedEndpoint.generatedClassName));
        }
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(WebSocketClientRecorder.ClientEndpointsContext.class).setRuntimeInit().supplier(recorder.createContext(endpointMap)).done());
    }

    @BuildStep
    void createSecurityChecksForHttpUpgradeCheck(Capabilities capabilities, BuildProducer<ClassSecurityAnnotationBuildItem> producer) {
        if (capabilities.isPresent("io.quarkus.security")) {
            producer.produce((BuildItem)new ClassSecurityAnnotationBuildItem(WebSocketDotNames.WEB_SOCKET));
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void createHttpUpgradeSecurityInterceptor(WebSocketServerRecorder recorder, BuildProducer<SyntheticBeanBuildItem> producer, List<WebSocketEndpointBuildItem> endpoints, List<EagerSecurityInterceptorClassesBuildItem> eagerSecurityInterceptorClassesBuildItems) {
        if (!eagerSecurityInterceptorClassesBuildItems.isEmpty()) {
            Set classesWithSecurityInterceptors = EagerSecurityInterceptorClassesBuildItem.collectInterceptedClasses(eagerSecurityInterceptorClassesBuildItems);
            Map<String, String> classNameToEndpointId = endpoints.stream().filter(i -> classesWithSecurityInterceptors.contains(i.beanClassName().toString())).collect(Collectors.toMap(i -> i.beanClassName().toString(), i -> i.id));
            producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(HttpUpgradeSecurityInterceptor.class).types(new Class[]{HttpUpgradeCheck.class})).scope(BuiltinScope.SINGLETON.getInfo())).priority(2147483557)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(EagerSecurityInterceptorStorage.class)), new AnnotationInstance[0])).createWith(recorder.createHttpUpgradeSecurityInterceptor(classNameToEndpointId)).done());
        }
    }

    @BuildStep
    void preventRepeatedSecurityChecksForHttpUpgrade(Capabilities capabilities, CombinedIndexBuildItem indexBuildItem, BuildProducer<AnnotationsTransformerBuildItem> producer, Optional<SecurityTransformerBuildItem> securityTransformerBuildItem) {
        if (capabilities.isPresent("io.quarkus.security") && WebSocketProcessor.identityUpdateNotSupported(indexBuildItem.getIndex())) {
            SecurityTransformer securityTransformer = SecurityTransformerBuildItem.createSecurityTransformer((IndexView)indexBuildItem.getIndex(), securityTransformerBuildItem);
            producer.produce((BuildItem)new AnnotationsTransformerBuildItem(((AnnotationTransformation.ClassBuilder)AnnotationTransformation.forClasses().whenAnyMatch(new DotName[]{WebSocketDotNames.WEB_SOCKET})).transform(ctx -> ctx.remove(ai -> securityTransformer.isSecurityAnnotation(ai, new SecurityTransformer.AuthorizationType[]{SecurityTransformer.AuthorizationType.SECURITY_CHECK})))));
        }
    }

    @BuildStep
    EndpointSecurityChecksBuildItem collectEndpointSecurityChecks(BeanArchiveIndexBuildItem indexItem, List<WebSocketEndpointBuildItem> endpoints, Optional<ClassSecurityCheckStorageBuildItem> storageItem, Capabilities capabilities, Optional<SecurityTransformerBuildItem> securityTransformerBuildItem) {
        Map<String, SecurityCheck> endpointIdToSecurityCheck;
        if (capabilities.isPresent("io.quarkus.security") && storageItem.isPresent()) {
            SecurityTransformer securityTransformer = SecurityTransformerBuildItem.createSecurityTransformer((IndexView)indexItem.getIndex(), securityTransformerBuildItem);
            endpointIdToSecurityCheck = WebSocketProcessor.collectEndpointSecurityChecks(endpoints, storageItem.get(), indexItem.getIndex(), securityTransformer);
        } else {
            endpointIdToSecurityCheck = Map.of();
        }
        return new EndpointSecurityChecksBuildItem(endpointIdToSecurityCheck);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void createSecurityHttpUpgradeCheck(BuildProducer<SyntheticBeanBuildItem> producer, EndpointSecurityChecksBuildItem endpointSecurityChecks, WebSocketServerRecorder recorder) {
        Map<String, SecurityCheck> endpointIdToSecurityCheck = endpointSecurityChecks.endpointIdToSecurityCheck;
        if (!endpointIdToSecurityCheck.isEmpty()) {
            producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SecurityHttpUpgradeCheck.class).types(new Class[]{HttpUpgradeCheck.class})).scope(BuiltinScope.SINGLETON.getInfo())).priority(2147483547)).setRuntimeInit().addInjectionPoint((Type)ClassType.create((DotName)DotNames.BEAN_MANAGER), new AnnotationInstance[0])).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.EVENT, (Type[])new Type[]{ClassType.create(AuthorizationFailureEvent.class)}), new AnnotationInstance[0])).addInjectionPoint((Type)ParameterizedType.create((DotName)DotNames.EVENT, (Type[])new Type[]{ClassType.create(AuthorizationSuccessEvent.class)}), new AnnotationInstance[0])).addInjectionPoint((Type)ClassType.create(WebSocketsServerRuntimeConfig.class), new AnnotationInstance[0])).createWith(recorder.createSecurityHttpUpgradeCheck(endpointIdToSecurityCheck)).done());
        }
    }

    @BuildStep
    void createHeaderPropagationHandler(BuildProducer<FilterBuildItem> filterProducer, WebSocketsServerBuildConfig buildConfig) {
        if (buildConfig.propagateSubprotocolHeaders()) {
            WebSocketHeaderPropagationHandler handler = new WebSocketHeaderPropagationHandler();
            int priority = 220;
            filterProducer.produce((BuildItem)new FilterBuildItem((Handler)handler, priority));
        }
    }

    @BuildStep
    void addMetricsSupport(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (WebSocketProcessor.isMetricsSupportEnabled(metricsCapability)) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(MetricsBuilderCustomizer.class));
        }
    }

    @BuildStep
    void addTracesSupport(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        if (WebSocketProcessor.isTracesSupportEnabled(capabilities)) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(TracesBuilderCustomizer.class));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createTelemetryProvider(BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, Capabilities capabilities, WebSocketTelemetryRecorder recorder, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (WebSocketProcessor.isTracesSupportEnabled(capabilities) || WebSocketProcessor.isMetricsSupportEnabled(metricsCapability)) {
            SyntheticBeanBuildItem syntheticBeanBuildItem = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(WebSocketTelemetryProvider.class).setRuntimeInit().unremovable()).addInjectionPoint((Type)ParameterizedType.builder(Instance.class).addArgument((Type)ParameterizedType.builder(Consumer.class).addArgument(WebSocketTelemetryProviderBuilder.class).build()).build(), new AnnotationInstance[0])).createWith(recorder.createTelemetryProvider()).scope(Singleton.class)).done();
            syntheticBeanProducer.produce((BuildItem)syntheticBeanBuildItem);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void supportSecurityIdentityUpdate(BeanDiscoveryFinishedBuildItem beanDiscoveryFinishedBuildItem, WebSocketServerRecorder recorder, Capabilities capabilities, CombinedIndexBuildItem indexBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer) {
        if (capabilities.isMissing("io.quarkus.security")) {
            return;
        }
        boolean isWsSecurityInjected = beanDiscoveryFinishedBuildItem.getInjectionPoints().stream().map(InjectionPointInfo::getType).filter(Objects::nonNull).map(Type::name).anyMatch(arg_0 -> ((DotName)WEBSOCKET_SECURITY_NAME).equals(arg_0));
        if (isWsSecurityInjected) {
            if (WebSocketProcessor.identityUpdateNotSupported(indexBuildItem.getIndex())) {
                throw new IllegalStateException("Quarkus did not detect " + String.valueOf(WEBSOCKET_SECURITY_NAME) + " injection, please report this issue to Quarkus project");
            }
            syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)WEBSOCKET_SECURITY_NAME).addInjectionPoint((Type)ClassType.create(IdentityProviderManager.class), new AnnotationInstance[0])).addInjectionPoint((Type)ParameterizedType.create(Instance.class, (Type[])new Type[]{ParameterizedType.create((DotName)DotName.createSimple(IdentityProvider.class), (Type[])new Type[]{WildcardType.UNBOUNDED})}), new AnnotationInstance[0])).createWith(recorder.createWebSocketSecurity()).scope(ApplicationScoped.class)).done());
        }
    }

    @BuildStep
    void createSecurityIdentityAssociation(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        if (capabilities.isPresent("io.quarkus.security")) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(WebSocketSecurityIdentityAssociation.class));
        }
    }

    private static boolean identityUpdateNotSupported(IndexView index) {
        return index.getKnownUsers(WEBSOCKET_SECURITY_NAME).isEmpty();
    }

    private static boolean isTracesSupportEnabled(Capabilities capabilities) {
        return capabilities.isPresent("io.quarkus.opentelemetry.tracer");
    }

    private static boolean isMetricsSupportEnabled(Optional<MetricsCapabilityBuildItem> metricsCapability) {
        return metricsCapability.map(m -> m.metricsSupported("micrometer")).orElse(false);
    }

    private static Map<String, SecurityCheck> collectEndpointSecurityChecks(List<WebSocketEndpointBuildItem> endpoints, ClassSecurityCheckStorageBuildItem storage, IndexView index, SecurityTransformer securityTransformer) {
        return endpoints.stream().mapMulti((endpoint, consumer) -> {
            DotName beanName = endpoint.beanClassName();
            Object patt0$temp = storage.getSecurityCheck(beanName);
            if (patt0$temp instanceof SecurityCheck) {
                SecurityCheck check = (SecurityCheck)patt0$temp;
                consumer.accept(Map.entry(endpoint.id, check));
            } else if (securityTransformer.hasSecurityAnnotation((AnnotationTarget)index.getClassByName(beanName), new SecurityTransformer.AuthorizationType[0])) {
                throw new IllegalStateException("WebSocket endpoint '%s' requires ".formatted(beanName) + "secured HTTP upgrade but Quarkus did not configure security check correctly. Please open issue in Quarkus project");
            }
        }).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static String mergePath(String prefix, String path) {
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return prefix + (String)path;
    }

    static String getPath(String path) {
        if (path.isEmpty()) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        Matcher m = PATH_PARAM_PATTERN.matcher(path);
        while (m.find()) {
            char nextChar;
            String match = m.group();
            int end = m.end();
            if (end < path.length() && (Character.isAlphabetic(nextChar = path.charAt(end)) || Character.isDigit(nextChar) || nextChar == '_')) {
                throw new WebSocketServerException("Path parameter " + match + " may not be followed by an alphanumeric character or underscore: " + path);
            }
            m.appendReplacement(sb, ":" + String.valueOf(match.subSequence(1, match.length() - 1)));
        }
        m.appendTail(sb);
        return path.startsWith("/") ? sb.toString() : "/" + sb.toString();
    }

    public static String getOriginalPath(String path) {
        StringBuilder sb = new StringBuilder();
        Matcher m = TRANSLATED_PATH_PARAM_PATTERN.matcher(path);
        while (m.find()) {
            String match = m.group();
            m.appendReplacement(sb, "{" + String.valueOf(match.subSequence(1, match.length())) + "}");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static String getPathPrefix(IndexView index, DotName enclosingClassName) {
        ClassInfo enclosingClass = index.getClassByName(enclosingClassName);
        if (enclosingClass == null) {
            throw new WebSocketServerException("Enclosing class not found in index: " + String.valueOf(enclosingClass));
        }
        AnnotationInstance webSocketAnnotation = enclosingClass.annotation(WebSocketDotNames.WEB_SOCKET);
        if (webSocketAnnotation != null) {
            String path = WebSocketProcessor.getPath(webSocketAnnotation.value("path").asString());
            if (enclosingClass.nestingType() == ClassInfo.NestingType.INNER) {
                return WebSocketProcessor.mergePath(WebSocketProcessor.getPathPrefix(index, enclosingClass.enclosingClass()), path);
            }
            return path.endsWith("/") ? path.substring(path.length() - 1) : path;
        }
        return "";
    }

    private void validateOnPingMessage(Callback callback) {
        Type messageType;
        if (KotlinUtils.isKotlinMethod((MethodInfo)callback.method)) {
            if (!(callback.isReturnTypeVoid() || WebSocketProcessor.isUniVoid(callback.returnType()) || callback.isKotlinSuspendFunctionReturningUnit())) {
                throw new WebSocketServerException("@OnPingMessage callback must return Unit or Uni<Void>: " + callback.asString());
            }
        } else if (!callback.isReturnTypeVoid() && !WebSocketProcessor.isUniVoid(callback.returnType())) {
            throw new WebSocketServerException("@OnPingMessage callback must return void or Uni<Void>: " + callback.asString());
        }
        if ((messageType = callback.argumentType(MessageCallbackArgument::isMessage)) == null || !messageType.name().equals((Object)WebSocketDotNames.BUFFER)) {
            throw new WebSocketServerException("@OnPingMessage callback must accept exactly one message parameter of type io.vertx.core.buffer.Buffer: " + callback.asString());
        }
    }

    private void validateOnPongMessage(Callback callback) {
        Type messageType;
        if (KotlinUtils.isKotlinMethod((MethodInfo)callback.method)) {
            if (!(callback.isReturnTypeVoid() || WebSocketProcessor.isUniVoid(callback.returnType()) || callback.isKotlinSuspendFunctionReturningUnit())) {
                throw new WebSocketServerException("@OnPongMessage callback must return Unit or Uni<Void>: " + callback.asString());
            }
        } else if (!callback.isReturnTypeVoid() && !WebSocketProcessor.isUniVoid(callback.returnType())) {
            throw new WebSocketServerException("@OnPongMessage callback must return void or Uni<Void>: " + callback.asString());
        }
        if ((messageType = callback.argumentType(MessageCallbackArgument::isMessage)) == null || !messageType.name().equals((Object)WebSocketDotNames.BUFFER)) {
            throw new WebSocketServerException("@OnPongMessage callback must accept exactly one message parameter of type io.vertx.core.buffer.Buffer: " + callback.asString());
        }
    }

    private void validateOnClose(Callback callback) {
        if (KotlinUtils.isKotlinMethod((MethodInfo)callback.method)) {
            if (!(callback.isReturnTypeVoid() || WebSocketProcessor.isUniVoid(callback.returnType()) || callback.isKotlinSuspendFunctionReturningUnit())) {
                throw new WebSocketServerException("@OnClose callback must return Unit or Uni<Void>: " + callback.asString());
            }
        } else if (!callback.isReturnTypeVoid() && !WebSocketProcessor.isUniVoid(callback.returnType())) {
            throw new WebSocketServerException("@OnClose callback must return void or Uni<Void>: " + callback.asString());
        }
    }

    static String generateEndpoint(WebSocketEndpointBuildItem endpoint, TransformedAnnotationsBuildItem transformedAnnotations, IndexView index, Gizmo gizmo, GlobalErrorHandlersBuildItem globalErrorHandlers, String endpointSuffix, InvokerFactoryBuildItem invokerFactory, boolean metricsSupportEnabled) {
        String generatedName = String.valueOf(endpoint.bean.getImplClazz().name()) + endpointSuffix;
        gizmo.class_(generatedName, cc -> {
            Callback callback;
            cc.extends_(WebSocketEndpointBase.class);
            FieldDesc onOpenInvoker = WebSocketProcessor.generateInvokerFieldIfNeeded(cc, endpoint.onOpen, "Open", invokerFactory);
            FieldDesc onBinaryMessageInvoker = WebSocketProcessor.generateInvokerFieldIfNeeded(cc, endpoint.onBinaryMessage, "BinaryMessage", invokerFactory);
            FieldDesc onTextMessageInvoker = WebSocketProcessor.generateInvokerFieldIfNeeded(cc, endpoint.onTextMessage, "TextMessage", invokerFactory);
            FieldDesc onPingMessageInvoker = WebSocketProcessor.generateInvokerFieldIfNeeded(cc, endpoint.onPingMessage, "PingMessage", invokerFactory);
            FieldDesc onPongMessageInvoker = WebSocketProcessor.generateInvokerFieldIfNeeded(cc, endpoint.onPongMessage, "PongMessage", invokerFactory);
            FieldDesc onCloseInvoker = WebSocketProcessor.generateInvokerFieldIfNeeded(cc, endpoint.onClose, "Close", invokerFactory);
            List<ErrorHandler> errorHandlers = WebSocketProcessor.generateErrorHandlers(cc, endpoint, globalErrorHandlers, index, invokerFactory);
            cc.constructor(mc -> {
                ParamVar base = mc.parameter("base", WebSocketConnectionBase.class);
                ParamVar codecs = mc.parameter("codecs", Codecs.class);
                ParamVar contextSupport = mc.parameter("contextSupport", ContextSupport.class);
                ParamVar securitySupport = mc.parameter("securitySupport", SecuritySupport.class);
                ParamVar errorInterceptor = mc.parameter("errorInterceptor", ErrorInterceptor.class);
                mc.body(bc -> {
                    bc.invokeSpecial(ConstructorDesc.of(WebSocketEndpointBase.class, (Class[])new Class[]{WebSocketConnectionBase.class, Codecs.class, ContextSupport.class, SecuritySupport.class, ErrorInterceptor.class}), (Expr)cc.this_(), new Expr[]{base, codecs, contextSupport, securitySupport, errorInterceptor});
                    bc.return_();
                });
            });
            cc.method("inboundProcessingMode", mc -> {
                mc.returning(InboundProcessingMode.class);
                mc.body(bc -> bc.return_((Expr)Const.of((Constable)endpoint.inboundProcessingMode)));
            });
            cc.method("beanIdentifier", mc -> {
                mc.returning(String.class);
                mc.body(bc -> bc.return_((Expr)Const.of((String)endpoint.bean.getIdentifier())));
            });
            if (endpoint.onOpen != null) {
                callback = endpoint.onOpen;
                cc.method("doOnOpen", mc -> {
                    mc.returning(Uni.class);
                    ParamVar payload = mc.parameter("payload", Object.class);
                    mc.body(WebSocketProcessor.catchAndCallOnError((Expr)cc.this_(), bc -> {
                        LocalVar beanInstance = bc.localVar("beanInstance", bc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[0]), (Expr)cc.this_()));
                        Expr[] args = callback.generateArguments((BlockCreator)bc, (Expr)cc.this_(), (Var)payload, transformedAnnotations, index);
                        Expr ret = WebSocketProcessor.callBusinessMethod(bc, callback, (Expr)beanInstance, args, (Expr)cc.this_(), onOpenInvoker);
                        WebSocketProcessor.encodeAndReturnResult(bc, (Expr)cc.this_(), callback, globalErrorHandlers, endpoint, ret, metricsSupportEnabled);
                    }));
                });
                cc.method("onOpenExecutionModel", mc -> {
                    mc.returning(WebSocketEndpoint.ExecutionModel.class);
                    mc.body(bc -> bc.return_((Expr)Const.of((Constable)callback.executionModel)));
                });
            }
            WebSocketProcessor.generateOnMessage(cc, endpoint, endpoint.onBinaryMessage, transformedAnnotations, index, globalErrorHandlers, onBinaryMessageInvoker, metricsSupportEnabled);
            WebSocketProcessor.generateOnMessage(cc, endpoint, endpoint.onTextMessage, transformedAnnotations, index, globalErrorHandlers, onTextMessageInvoker, metricsSupportEnabled);
            WebSocketProcessor.generateOnMessage(cc, endpoint, endpoint.onPingMessage, transformedAnnotations, index, globalErrorHandlers, onPingMessageInvoker, metricsSupportEnabled);
            WebSocketProcessor.generateOnMessage(cc, endpoint, endpoint.onPongMessage, transformedAnnotations, index, globalErrorHandlers, onPongMessageInvoker, metricsSupportEnabled);
            if (endpoint.onClose != null) {
                callback = endpoint.onClose;
                cc.method("doOnClose", mc -> {
                    mc.returning(Uni.class);
                    ParamVar payload = mc.parameter("payload", Object.class);
                    mc.body(WebSocketProcessor.catchAndCallOnError((Expr)cc.this_(), bc -> {
                        LocalVar beanInstance = bc.localVar("beanInstance", bc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[0]), (Expr)cc.this_()));
                        Expr[] args = callback.generateArguments((BlockCreator)bc, (Expr)cc.this_(), (Var)payload, transformedAnnotations, index);
                        Expr ret = WebSocketProcessor.callBusinessMethod(bc, callback, (Expr)beanInstance, args, (Expr)cc.this_(), onCloseInvoker);
                        WebSocketProcessor.encodeAndReturnResult(bc, (Expr)cc.this_(), callback, globalErrorHandlers, endpoint, ret, metricsSupportEnabled);
                    }));
                });
                cc.method("onCloseExecutionModel", mc -> {
                    mc.returning(WebSocketEndpoint.ExecutionModel.class);
                    mc.body(bc -> bc.return_((Expr)Const.of((Constable)callback.executionModel)));
                });
            }
            WebSocketProcessor.generateOnError(cc, errorHandlers, endpoint, transformedAnnotations, globalErrorHandlers, index, invokerFactory, metricsSupportEnabled);
        });
        return generatedName;
    }

    private static FieldDesc generateInvokerFieldIfNeeded(ClassCreator cc, Callback callback, String messageType, InvokerFactoryBuildItem invokerFactory) {
        if (callback != null && KotlinUtils.isKotlinSuspendMethod((MethodInfo)callback.method)) {
            return cc.field("invokerFor" + messageType, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Invoker.class);
                fc.setInitializer(bc -> {
                    InvokerInfo invoker = invokerFactory.createInvoker(callback.bean, callback.method).withInvocationWrapper(CoroutineInvoker.class, "inNewCoroutine").build();
                    bc.yield(bc.new_(ConstructorDesc.of((ClassDesc)invoker.getClassDesc())));
                });
            });
        }
        return null;
    }

    private static List<ErrorHandler> generateErrorHandlers(ClassCreator cc, WebSocketEndpointBuildItem endpoint, GlobalErrorHandlersBuildItem globalErrorHandlers, IndexView index, InvokerFactoryBuildItem invokerFactory) {
        ArrayList<ErrorHandler> result = new ArrayList<ErrorHandler>();
        HashMap<DotName, Callback> found = new HashMap<DotName, Callback>();
        for (Callback callback : endpoint.onErrors) {
            DotName errorTypeName = callback.argumentType(ErrorCallbackArgument::isError).name();
            if (found.containsKey(errorTypeName)) {
                throw new WebSocketException(String.format("Multiple @OnError callbacks may not accept the same error parameter: %s\n\t- %s\n\t- %s", errorTypeName, callback.asString(), ((Callback)found.get(errorTypeName)).asString()));
            }
            found.put(errorTypeName, callback);
            FieldDesc invoker = WebSocketProcessor.generateInvokerFieldIfNeeded(cc, callback, "Error_" + errorTypeName.withoutPackagePrefix(), invokerFactory);
            result.add(new ErrorHandler(endpoint.bean, callback, invoker, WebSocketProcessor.throwableHierarchy(errorTypeName, index)));
        }
        List<GlobalErrorHandler> handlers = endpoint.isClient ? globalErrorHandlers.forClient() : globalErrorHandlers.forServer();
        for (GlobalErrorHandler handler : handlers) {
            Callback callback = handler.callback;
            DotName errorTypeName = callback.argumentType(ErrorCallbackArgument::isError).name();
            if (found.containsKey(errorTypeName)) continue;
            FieldDesc invoker = WebSocketProcessor.generateInvokerFieldIfNeeded(cc, callback, "Error_" + errorTypeName.withoutPackagePrefix(), invokerFactory);
            result.add(new ErrorHandler(handler.bean, callback, invoker, WebSocketProcessor.throwableHierarchy(errorTypeName, index)));
        }
        result.sort(Comparator.comparingInt(ErrorHandler::level).reversed());
        return result;
    }

    private static void generateOnError(ClassCreator cc, List<ErrorHandler> errorHandlers, WebSocketEndpointBuildItem endpoint, TransformedAnnotationsBuildItem transformedAnnotations, GlobalErrorHandlersBuildItem globalErrorHandlers, IndexView index, InvokerFactoryBuildItem invokerFactory, boolean metricsSupportEnabled) {
        if (errorHandlers.isEmpty()) {
            return;
        }
        cc.method("doOnError", mc -> {
            mc.returning(Uni.class);
            ParamVar exception = mc.parameter("exception", Throwable.class);
            mc.body(b0 -> {
                if (metricsSupportEnabled) {
                    b0.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"interceptError", Void.TYPE, (Class[])new Class[]{Throwable.class}), (Expr)cc.this_(), (Expr)exception);
                }
                for (ErrorHandler errorHandler : errorHandlers) {
                    Callback callback = errorHandler.callback;
                    b0.ifInstanceOf((Expr)exception, Jandex2Gizmo.classDescOf((DotName)errorHandler.hierarchy.get(0)), (b1, e) -> {
                        Expr lambda = b1.lambda(Function.class, lc -> {
                            Var capturedThis = lc.capture("endpointThis", (Expr)cc.this_());
                            ParamVar ex = lc.parameter("exception", 0);
                            lc.body(WebSocketProcessor.catchAndReturnFailedUni(lbc -> {
                                Expr beanInstance = lbc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[]{String.class}), (Expr)capturedThis, (Expr)Const.of((String)errorHandler.bean.getIdentifier()));
                                Expr[] args = callback.generateArguments((BlockCreator)lbc, (Expr)capturedThis, (Var)ex, transformedAnnotations, index);
                                Expr ret = WebSocketProcessor.callBusinessMethod(lbc, callback, beanInstance, args, (Expr)capturedThis, errorHandler.invoker);
                                WebSocketProcessor.encodeAndReturnResult(lbc, (Expr)capturedThis, callback, globalErrorHandlers, endpoint, ret, metricsSupportEnabled);
                            }));
                        });
                        b1.return_(b1.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"doErrorExecute", Uni.class, (Class[])new Class[]{Throwable.class, WebSocketEndpoint.ExecutionModel.class, Function.class}), (Expr)cc.this_(), new Expr[]{exception, Const.of((Constable)callback.executionModel), lambda}));
                    });
                }
                Expr uniCreate = b0.invokeStatic(MethodDesc.of(Uni.class, (String)"createFrom", UniCreate.class, (Class[])new Class[0]));
                b0.return_(b0.invokeVirtual(MethodDesc.of(UniCreate.class, (String)"failure", Uni.class, (Class[])new Class[]{Throwable.class}), uniCreate, (Expr)exception));
            });
        });
    }

    private static List<DotName> throwableHierarchy(DotName throwableName, IndexView index) {
        ArrayList<DotName> ret = new ArrayList<DotName>();
        WebSocketProcessor.addToThrowableHierarchy(throwableName, index, ret);
        return ret;
    }

    private static void addToThrowableHierarchy(DotName throwableName, IndexView index, List<DotName> hierarchy) {
        hierarchy.add(throwableName);
        ClassInfo errorClass = index.getClassByName(throwableName);
        if (errorClass == null) {
            throw new IllegalArgumentException("The class " + String.valueOf(throwableName) + " not found in the index");
        }
        if (errorClass.superName().equals((Object)DotName.OBJECT_NAME)) {
            return;
        }
        WebSocketProcessor.addToThrowableHierarchy(errorClass.superName(), index, hierarchy);
    }

    private static void generateOnMessage(ClassCreator cc, WebSocketEndpointBuildItem endpoint, Callback callback, TransformedAnnotationsBuildItem transformedAnnotations, IndexView index, GlobalErrorHandlersBuildItem globalErrorHandlers, FieldDesc invoker, boolean metricsSupportEnabled) {
        String messageType;
        if (callback == null) {
            return;
        }
        cc.method("doOn" + messageType + "Message", arg_0 -> WebSocketProcessor.lambda$generateOnMessage$33(switch (callback.messageType()) {
            case Callback.MessageType.BINARY -> {
                messageType = "Binary";
                yield Object.class;
            }
            case Callback.MessageType.TEXT -> {
                messageType = "Text";
                yield Object.class;
            }
            case Callback.MessageType.PING -> {
                messageType = "Ping";
                yield Buffer.class;
            }
            case Callback.MessageType.PONG -> {
                messageType = "Pong";
                yield Buffer.class;
            }
            default -> throw new IllegalArgumentException("Unknown message type: " + String.valueOf((Object)callback.messageType()));
        }, cc, callback, transformedAnnotations, index, invoker, globalErrorHandlers, endpoint, metricsSupportEnabled, arg_0));
        cc.method("on" + messageType + "MessageExecutionModel", mc -> {
            mc.returning(WebSocketEndpoint.ExecutionModel.class);
            mc.body(bc -> bc.return_((Expr)Const.of((Constable)callback.executionModel)));
        });
        if (callback.acceptsMulti() && callback.messageType != Callback.MessageType.PING && callback.messageType != Callback.MessageType.PONG) {
            Type multiItemType = (Type)callback.messageParamType().asParameterizedType().arguments().get(0);
            cc.method("consumed" + messageType + "MultiType", mc -> {
                mc.returning(java.lang.reflect.Type.class);
                mc.body(bc -> bc.return_((Expr)RuntimeTypeCreator.of((BlockCreator)bc).create(multiItemType)));
            });
            cc.method("decode" + messageType + "MultiItem", mc -> {
                mc.returning(Object.class);
                ParamVar payload = mc.parameter("payload", Object.class);
                mc.body(bc -> bc.return_(WebSocketProcessor.decodeMessage(bc, (Expr)cc.this_(), callback.acceptsBinaryMessage(), multiItemType, (Var)payload, callback)));
            });
        }
    }

    private static Expr callBusinessMethod(BlockCreator bc, Callback callback, Expr beanInstance, Expr[] args, Expr endpointThis, FieldDesc invoker) {
        Expr result = invoker != null ? bc.invokeInterface(MethodDesc.of(Invoker.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class}), (Expr)endpointThis.field(invoker), beanInstance, bc.newArray(Object.class, args)) : bc.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)callback.method), beanInstance, args);
        return result.isVoid() ? result : bc.localVar("result", result);
    }

    private static Consumer<BlockCreator> catchAndReturnFailedUni(Consumer<BlockCreator> bcConsumer) {
        return b0 -> b0.try_(tc -> {
            tc.body(bcConsumer);
            tc.catch_(Throwable.class, "e", (b1, e) -> {
                Expr uniCreate = b1.invokeStatic(MethodDesc.of(Uni.class, (String)"createFrom", UniCreate.class, (Class[])new Class[0]));
                b1.return_(b1.invokeVirtual(MethodDesc.of(UniCreate.class, (String)"failure", Uni.class, (Class[])new Class[]{Throwable.class}), uniCreate, (Expr)e));
            });
        });
    }

    private static Consumer<BlockCreator> catchAndCallOnError(Expr this_, Consumer<BlockCreator> bcConsumer) {
        return b0 -> b0.try_(tc -> {
            tc.body(bcConsumer);
            tc.catch_(Throwable.class, "e", (b1, e) -> b1.return_(b1.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"doOnError", Uni.class, (Class[])new Class[]{Throwable.class}), this_, (Expr)e)));
        });
    }

    static Expr decodeMessage(BlockCreator bc, Expr endpointThis, boolean binaryMessage, Type valueType, Var value, Callback callback) {
        if (WebSocketDotNames.MULTI.equals((Object)valueType.name())) {
            return value;
        }
        if (binaryMessage) {
            if (WebSocketDotNames.BUFFER.equals((Object)valueType.name())) {
                return value;
            }
            if (WebSocketProcessor.isByteArray(valueType)) {
                return bc.invokeInterface(MethodDesc.of(Buffer.class, (String)"getBytes", byte[].class, (Class[])new Class[0]), (Expr)value);
            }
            if (WebSocketDotNames.STRING.equals((Object)valueType.name())) {
                return bc.invokeInterface(MethodDesc.of(Buffer.class, (String)"toString", String.class, (Class[])new Class[0]), (Expr)value);
            }
            if (WebSocketDotNames.JSON_OBJECT.equals((Object)valueType.name())) {
                return bc.new_(ConstructorDesc.of(JsonObject.class, (Class[])new Class[]{Buffer.class}), (Expr)value);
            }
            if (WebSocketDotNames.JSON_ARRAY.equals((Object)valueType.name())) {
                return bc.new_(ConstructorDesc.of(JsonArray.class, (Class[])new Class[]{Buffer.class}), (Expr)value);
            }
            DotName inputCodec = callback.getInputCodec();
            Const inputCodecClass = inputCodec != null ? Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)inputCodec)) : Const.ofNull(Class.class);
            LocalVar type = RuntimeTypeCreator.of((BlockCreator)bc).create(valueType);
            return bc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"decodeBinary", Object.class, (Class[])new Class[]{java.lang.reflect.Type.class, Buffer.class, Class.class}), endpointThis, new Expr[]{type, value, inputCodecClass});
        }
        if (WebSocketDotNames.STRING.equals((Object)valueType.name())) {
            return value;
        }
        if (WebSocketDotNames.JSON_OBJECT.equals((Object)valueType.name())) {
            return bc.new_(ConstructorDesc.of(JsonObject.class, (Class[])new Class[]{String.class}), (Expr)value);
        }
        if (WebSocketDotNames.JSON_ARRAY.equals((Object)valueType.name())) {
            return bc.new_(ConstructorDesc.of(JsonArray.class, (Class[])new Class[]{String.class}), (Expr)value);
        }
        if (WebSocketDotNames.BUFFER.equals((Object)valueType.name())) {
            return bc.invokeStatic(MethodDesc.of(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{String.class}), (Expr)value);
        }
        if (WebSocketProcessor.isByteArray(valueType)) {
            Expr buffer = bc.invokeStatic(MethodDesc.of(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), (Expr)value);
            return bc.invokeInterface(MethodDesc.of(Buffer.class, (String)"getBytes", byte[].class, (Class[])new Class[0]), buffer);
        }
        DotName inputCodec = callback.getInputCodec();
        Const inputCodecClass = inputCodec != null ? Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)inputCodec)) : Const.ofNull(Class.class);
        LocalVar type = RuntimeTypeCreator.of((BlockCreator)bc).create(valueType);
        return bc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"decodeText", Object.class, (Class[])new Class[]{java.lang.reflect.Type.class, String.class, Class.class}), endpointThis, new Expr[]{type, value, inputCodecClass});
    }

    private static Expr uniOnFailureDoOnError(BlockCreator bc, Expr endpointThis, Callback callback, Expr uni, WebSocketEndpointBuildItem endpoint, GlobalErrorHandlersBuildItem globalErrorHandlers, boolean metricsSupportEnabled) {
        if ((callback.isOnError() || globalErrorHandlers.handlers.isEmpty() && (endpoint == null || endpoint.onErrors.isEmpty())) && !metricsSupportEnabled) {
            return uni;
        }
        Expr uniOnFailure = bc.invokeInterface(MethodDesc.of(Uni.class, (String)"onFailure", UniOnFailure.class, (Class[])new Class[0]), uni);
        Expr lambda = bc.lambda(Function.class, lc -> {
            Var capturedThis = lc.capture("endpointThis", endpointThis);
            ParamVar exception = lc.parameter("exception", 0);
            lc.body(lbc -> lbc.return_(lbc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"doOnError", Uni.class, (Class[])new Class[]{Throwable.class}), (Expr)capturedThis, (Expr)exception)));
        });
        return bc.invokeVirtual(MethodDesc.of(UniOnFailure.class, (String)"recoverWithUni", Uni.class, (Class[])new Class[]{Function.class}), uniOnFailure, lambda);
    }

    private static Expr encodeMessage(Expr endpointThis, BlockCreator bc, Callback callback, GlobalErrorHandlersBuildItem globalErrorHandlers, WebSocketEndpointBuildItem endpoint, Expr value, boolean metricsSupportEnabled) {
        if (callback.acceptsBinaryMessage() || WebSocketProcessor.isOnOpenWithBinaryReturnType(callback)) {
            if (callback.isReturnTypeUni() || callback.isKotlinSuspendFunction()) {
                Type messageType;
                Type type = messageType = callback.isReturnTypeUni() ? (Type)callback.returnType().asParameterizedType().arguments().get(0) : KotlinUtils.getKotlinSuspendMethodResult((MethodInfo)callback.method);
                if (messageType.name().equals((Object)KotlinDotNames.UNIT)) {
                    value = bc.invokeInterface(MethodDesc.of(Uni.class, (String)"replaceWithVoid", Uni.class, (Class[])new Class[0]), value);
                    messageType = ClassType.create((DotName)WebSocketDotNames.VOID);
                }
                if (messageType.name().equals((Object)WebSocketDotNames.VOID)) {
                    return WebSocketProcessor.uniOnFailureDoOnError(bc, endpointThis, callback, value, endpoint, globalErrorHandlers, metricsSupportEnabled);
                }
                Type messageTypeFinal = messageType;
                Expr lambda = bc.lambda(Function.class, lc -> {
                    Var capturedThis = lc.capture("endpointThis", endpointThis);
                    ParamVar buffer = lc.parameter("buffer", 0);
                    lc.body(lbc -> {
                        Expr encoded = WebSocketProcessor.encodeBuffer(lbc, messageTypeFinal, (Expr)buffer, (Expr)capturedThis, callback);
                        lbc.return_(lbc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"sendBinary", Uni.class, (Class[])new Class[]{Buffer.class, Boolean.TYPE}), (Expr)capturedThis, encoded, (Expr)Const.of((boolean)callback.broadcast())));
                    });
                });
                Expr uniChain = bc.invokeInterface(MethodDesc.of(Uni.class, (String)"chain", Uni.class, (Class[])new Class[]{Function.class}), value, lambda);
                return WebSocketProcessor.uniOnFailureDoOnError(bc, endpointThis, callback, uniChain, endpoint, globalErrorHandlers, metricsSupportEnabled);
            }
            if (callback.isReturnTypeMulti()) {
                Expr lambda = bc.lambda(Function.class, lc -> {
                    Var capturedThis = lc.capture("endpointThis", endpointThis);
                    ParamVar buffer = lc.parameter("buffer", 0);
                    lc.body(WebSocketProcessor.catchAndCallOnError((Expr)capturedThis, lbc -> {
                        Expr encoded = WebSocketProcessor.encodeBuffer(lbc, (Type)callback.returnType().asParameterizedType().arguments().get(0), (Expr)buffer, (Expr)capturedThis, callback);
                        lbc.return_(lbc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"sendBinary", Uni.class, (Class[])new Class[]{Buffer.class, Boolean.TYPE}), (Expr)capturedThis, encoded, (Expr)Const.of((boolean)callback.broadcast())));
                    }));
                });
                return bc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"multiBinary", Uni.class, (Class[])new Class[]{Multi.class, Function.class}), endpointThis, value, lambda);
            }
            Expr buffer = WebSocketProcessor.encodeBuffer(bc, callback.returnType(), value, endpointThis, callback);
            return bc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"sendBinary", Uni.class, (Class[])new Class[]{Buffer.class, Boolean.TYPE}), endpointThis, buffer, (Expr)Const.of((boolean)callback.broadcast()));
        }
        if (callback.isReturnTypeUni() || callback.isKotlinSuspendFunction()) {
            Type messageType;
            Type type = messageType = callback.isReturnTypeUni() ? (Type)callback.returnType().asParameterizedType().arguments().get(0) : KotlinUtils.getKotlinSuspendMethodResult((MethodInfo)callback.method);
            if (messageType.name().equals((Object)KotlinDotNames.UNIT)) {
                value = bc.invokeInterface(MethodDesc.of(Uni.class, (String)"replaceWithVoid", Uni.class, (Class[])new Class[0]), value);
                messageType = ClassType.create((DotName)WebSocketDotNames.VOID);
            }
            if (messageType.name().equals((Object)WebSocketDotNames.VOID)) {
                return WebSocketProcessor.uniOnFailureDoOnError(bc, endpointThis, callback, value, endpoint, globalErrorHandlers, metricsSupportEnabled);
            }
            Type messageTypeFinal = messageType;
            Expr lambda = bc.lambda(Function.class, lc -> {
                Var capturedThis = lc.capture("endpointThis", endpointThis);
                ParamVar text = lc.parameter("text", 0);
                lc.body(lbc -> {
                    Expr encoded = WebSocketProcessor.encodeText(lbc, messageTypeFinal, (Expr)text, (Expr)capturedThis, callback);
                    lbc.return_(lbc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"sendText", Uni.class, (Class[])new Class[]{String.class, Boolean.TYPE}), (Expr)capturedThis, encoded, (Expr)Const.of((boolean)callback.broadcast())));
                });
            });
            Expr uniChain = bc.invokeInterface(MethodDesc.of(Uni.class, (String)"chain", Uni.class, (Class[])new Class[]{Function.class}), value, lambda);
            return WebSocketProcessor.uniOnFailureDoOnError(bc, endpointThis, callback, uniChain, endpoint, globalErrorHandlers, metricsSupportEnabled);
        }
        if (callback.isReturnTypeMulti()) {
            Expr lambda = bc.lambda(Function.class, lc -> {
                Var capturedThis = lc.capture("endpointThis", endpointThis);
                ParamVar text = lc.parameter("text", 0);
                lc.body(WebSocketProcessor.catchAndCallOnError((Expr)capturedThis, lbc -> {
                    Expr encoded = WebSocketProcessor.encodeText(lbc, (Type)callback.returnType().asParameterizedType().arguments().get(0), (Expr)text, (Expr)capturedThis, callback);
                    lbc.return_(lbc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"sendText", Uni.class, (Class[])new Class[]{String.class, Boolean.TYPE}), (Expr)capturedThis, encoded, (Expr)Const.of((boolean)callback.broadcast())));
                }));
            });
            return bc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"multiText", Uni.class, (Class[])new Class[]{Multi.class, Function.class}), endpointThis, value, lambda);
        }
        Expr text = WebSocketProcessor.encodeText(bc, callback.returnType(), value, endpointThis, callback);
        return bc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"sendText", Uni.class, (Class[])new Class[]{String.class, Boolean.TYPE}), endpointThis, text, (Expr)Const.of((boolean)callback.broadcast()));
    }

    private static Expr encodeBuffer(BlockCreator bc, Type messageType, Expr value, Expr endpointThis, Callback callback) {
        Expr buffer;
        if (messageType.name().equals((Object)WebSocketDotNames.BUFFER)) {
            buffer = value;
        } else if (WebSocketProcessor.isByteArray(messageType)) {
            buffer = bc.invokeStatic(MethodDesc.of(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), value);
        } else if (messageType.name().equals((Object)WebSocketDotNames.STRING)) {
            buffer = bc.invokeStatic(MethodDesc.of(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{String.class}), value);
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_OBJECT)) {
            buffer = bc.invokeVirtual(MethodDesc.of(JsonObject.class, (String)"toBuffer", Buffer.class, (Class[])new Class[0]), value);
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_ARRAY)) {
            buffer = bc.invokeVirtual(MethodDesc.of(JsonArray.class, (String)"toBuffer", Buffer.class, (Class[])new Class[0]), value);
        } else {
            DotName outputCodec = callback.getOutputCodec();
            Const outputCodecClass = outputCodec != null ? Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)outputCodec)) : Const.ofNull(Class.class);
            buffer = bc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"encodeBinary", Buffer.class, (Class[])new Class[]{Object.class, Class.class}), endpointThis, value, (Expr)outputCodecClass);
        }
        return buffer;
    }

    private static Expr encodeText(BlockCreator bc, Type messageType, Expr value, Expr endpointThis, Callback callback) {
        Expr text;
        if (messageType.name().equals((Object)WebSocketDotNames.BUFFER)) {
            text = bc.invokeInterface(MethodDesc.of(Buffer.class, (String)"toString", String.class, (Class[])new Class[0]), value);
        } else if (WebSocketProcessor.isByteArray(messageType)) {
            Expr buffer = bc.invokeStatic(MethodDesc.of(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), value);
            text = bc.invokeInterface(MethodDesc.of(Buffer.class, (String)"toString", String.class, (Class[])new Class[0]), buffer);
        } else if (messageType.name().equals((Object)WebSocketDotNames.STRING)) {
            text = value;
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_OBJECT)) {
            text = bc.invokeVirtual(MethodDesc.of(JsonObject.class, (String)"encode", String.class, (Class[])new Class[0]), value);
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_ARRAY)) {
            text = bc.invokeVirtual(MethodDesc.of(JsonArray.class, (String)"encode", String.class, (Class[])new Class[0]), value);
        } else {
            DotName outputCodec = callback.getOutputCodec();
            Const outputCodecClass = outputCodec != null ? Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)outputCodec)) : Const.ofNull(Class.class);
            text = bc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"encodeText", String.class, (Class[])new Class[]{Object.class, Class.class}), endpointThis, value, (Expr)outputCodecClass);
        }
        return text;
    }

    private static Expr uniVoid(BlockCreator bc) {
        Expr uniCreate = bc.invokeStatic(MethodDesc.of(Uni.class, (String)"createFrom", UniCreate.class, (Class[])new Class[0]));
        return bc.invokeVirtual(MethodDesc.of(UniCreate.class, (String)"voidItem", Uni.class, (Class[])new Class[0]), uniCreate);
    }

    private static void encodeAndReturnResult(BlockCreator b0, Expr endpointThis, Callback callback, GlobalErrorHandlersBuildItem globalErrorHandlers, WebSocketEndpointBuildItem endpoint, Expr result, boolean metricsSupportEnabled) {
        if (callback.isReturnTypeVoid()) {
            b0.return_(WebSocketProcessor.uniVoid(b0));
        } else {
            b0.ifNull(result, b1 -> b1.return_(WebSocketProcessor.uniVoid(b1)));
            b0.return_(WebSocketProcessor.encodeMessage(endpointThis, b0, callback, globalErrorHandlers, endpoint, result, metricsSupportEnabled));
        }
    }

    static List<Callback> findErrorHandlers(Callback.Target expectedTarget, IndexView index, BeanInfo bean, ClassInfo beanClass, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, String endpointPath) {
        List<AnnotationInstance> annotations = WebSocketProcessor.findCallbackAnnotations(index, beanClass, WebSocketDotNames.ON_ERROR);
        if (annotations.isEmpty()) {
            return List.of();
        }
        ArrayList<Callback> errorHandlers = new ArrayList<Callback>(annotations.size());
        for (AnnotationInstance annotation : annotations) {
            Callback.Target target;
            MethodInfo method = annotation.target().asMethod();
            if (method.parameterTypes().stream().map(Type::name).anyMatch(arg_0 -> ((DotName)WebSocketDotNames.WEB_SOCKET_CONNECTION).equals(arg_0))) {
                target = Callback.Target.SERVER;
                if (expectedTarget == Callback.Target.CLIENT) {
                    throw new WebSocketException("@OnError callback on @WebSocketClient must not accept WebSocketConnection: " + String.valueOf(method.declaringClass()) + "." + method.name() + "()");
                }
            } else if (method.parameterTypes().stream().map(Type::name).anyMatch(arg_0 -> ((DotName)WebSocketDotNames.WEB_SOCKET_CLIENT_CONNECTION).equals(arg_0))) {
                target = Callback.Target.CLIENT;
                if (expectedTarget == Callback.Target.SERVER) {
                    throw new WebSocketException("@OnError callback on @WebSocket must not accept WebSocketClientConnection: " + String.valueOf(method.declaringClass()) + "." + method.name() + "()");
                }
            } else {
                target = Callback.Target.UNDEFINED;
            }
            Callback callback = new Callback(target, annotation, bean, method, WebSocketProcessor.executionModel(method, transformedAnnotations), callbackArguments, transformedAnnotations, endpointPath, index);
            long errorArguments = callback.arguments.stream().filter(ca -> ca instanceof ErrorCallbackArgument).count();
            if (errorArguments != 1L) {
                throw new WebSocketException(String.format("@OnError callback must accept exactly one error parameter; found %s: %s", errorArguments, callback.asString()));
            }
            errorHandlers.add(callback);
        }
        return errorHandlers;
    }

    private static List<AnnotationInstance> findCallbackAnnotations(IndexView index, ClassInfo beanClass, DotName annotationName) {
        ClassInfo clazz = beanClass;
        ArrayList<AnnotationInstance> annotations = new ArrayList<AnnotationInstance>();
        while (clazz != null) {
            DotName superName;
            List declared = (List)clazz.annotationsMap().get(annotationName);
            if (declared != null) {
                annotations.addAll(declared);
            }
            clazz = (superName = clazz.superName()) != null && !superName.equals((Object)DotNames.OBJECT) ? index.getClassByName(superName) : null;
        }
        return annotations;
    }

    static Callback findCallback(Callback.Target target, IndexView index, BeanInfo bean, ClassInfo beanClass, DotName annotationName, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, String endpointPath) {
        return WebSocketProcessor.findCallback(target, index, bean, beanClass, annotationName, callbackArguments, transformedAnnotations, endpointPath, null);
    }

    private static Callback findCallback(Callback.Target target, IndexView index, BeanInfo bean, ClassInfo beanClass, DotName annotationName, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, String endpointPath, Consumer<Callback> validator) {
        List<AnnotationInstance> annotations = WebSocketProcessor.findCallbackAnnotations(index, beanClass, annotationName);
        if (annotations.isEmpty()) {
            return null;
        }
        if (annotations.size() == 1) {
            AnnotationInstance annotation = annotations.get(0);
            MethodInfo method = annotation.target().asMethod();
            Callback callback = new Callback(target, annotation, bean, method, WebSocketProcessor.executionModel(method, transformedAnnotations), callbackArguments, transformedAnnotations, endpointPath, index);
            long messageArguments = callback.arguments.stream().filter(ca -> ca instanceof MessageCallbackArgument).count();
            if (callback.acceptsMessage()) {
                if (messageArguments > 1L) {
                    throw new WebSocketException(String.format("@%s callback may accept at most 1 message parameter; found %s: %s", DotNames.simpleName((DotName)callback.annotation.name()), messageArguments, callback.asString()));
                }
            } else if (messageArguments != 0L) {
                throw new WebSocketException(String.format("@%s callback must not accept a message parameter; found %s: %s", DotNames.simpleName((DotName)callback.annotation.name()), messageArguments, callback.asString()));
            }
            if (target == Callback.Target.CLIENT && callback.broadcast()) {
                throw new WebSocketClientException(String.format("@%s callback declared on a client endpoint must not broadcast messages: %s", DotNames.simpleName((DotName)callback.annotation.name()), callback.asString()));
            }
            if (validator != null) {
                validator.accept(callback);
            }
            return callback;
        }
        throw new WebSocketException(String.format("There can be only one callback annotated with %s declared on %s", annotationName, beanClass));
    }

    private static WebSocketEndpoint.ExecutionModel executionModel(MethodInfo method, TransformedAnnotationsBuildItem transformedAnnotations) {
        if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method) && (transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), WebSocketDotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.BLOCKING) || transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.NON_BLOCKING))) {
            throw new WebSocketException("Kotlin `suspend` functions in WebSockets Next endpoints may not be annotated @Blocking, @NonBlocking or @RunOnVirtualThread: " + String.valueOf(method));
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), WebSocketDotNames.RUN_ON_VIRTUAL_THREAD)) {
            return WebSocketEndpoint.ExecutionModel.VIRTUAL_THREAD;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.BLOCKING)) {
            return WebSocketEndpoint.ExecutionModel.WORKER_THREAD;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.NON_BLOCKING)) {
            return WebSocketEndpoint.ExecutionModel.EVENT_LOOP;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.TRANSACTIONAL) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), WebSocketDotNames.TRANSACTIONAL)) {
            return WebSocketEndpoint.ExecutionModel.WORKER_THREAD;
        }
        return WebSocketProcessor.hasBlockingSignature(method) ? WebSocketEndpoint.ExecutionModel.WORKER_THREAD : WebSocketEndpoint.ExecutionModel.EVENT_LOOP;
    }

    static boolean hasBlockingSignature(MethodInfo method) {
        if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
            return false;
        }
        return switch (method.returnType().kind()) {
            case Type.Kind.VOID, Type.Kind.CLASS, Type.Kind.ARRAY -> true;
            case Type.Kind.PARAMETERIZED_TYPE -> {
                DotName name = method.returnType().asParameterizedType().name();
                if (!name.equals((Object)WebSocketDotNames.UNI) && !name.equals((Object)WebSocketDotNames.MULTI)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new WebSocketServerException("Unsupported return type:" + WebSocketProcessor.methodToString(method));
        };
    }

    static boolean isUniVoid(Type type) {
        return WebSocketDotNames.UNI.equals((Object)type.name()) && ((Type)type.asParameterizedType().arguments().get(0)).name().equals((Object)WebSocketDotNames.VOID);
    }

    static boolean isByteArray(Type type) {
        return type.kind() == Type.Kind.ARRAY && PrimitiveType.BYTE.equals((Object)type.asArrayType().constituent());
    }

    static String methodToString(MethodInfo method) {
        return String.valueOf(method.declaringClass().name()) + "#" + method.name() + "()";
    }

    private static boolean isOnOpenWithBinaryReturnType(Callback callback) {
        if (callback.isOnOpen()) {
            Type returnType = callback.returnType();
            if (callback.isReturnTypeUni() || callback.isReturnTypeMulti()) {
                returnType = (Type)callback.returnType().asParameterizedType().arguments().get(0);
            } else if (callback.isKotlinSuspendFunction()) {
                returnType = KotlinUtils.getKotlinSuspendMethodResult((MethodInfo)callback.method);
            }
            return WebSocketDotNames.BUFFER.equals((Object)returnType.name()) || returnType.kind() == Type.Kind.ARRAY && PrimitiveType.BYTE.equals((Object)returnType.asArrayType().constituent());
        }
        return false;
    }

    private static /* synthetic */ void lambda$generateOnMessage$33(Class methodParameterType, ClassCreator cc, Callback callback, TransformedAnnotationsBuildItem transformedAnnotations, IndexView index, FieldDesc invoker, GlobalErrorHandlersBuildItem globalErrorHandlers, WebSocketEndpointBuildItem endpoint, boolean metricsSupportEnabled, InstanceMethodCreator mc) {
        mc.returning(Uni.class);
        ParamVar payload = mc.parameter("payload", methodParameterType);
        mc.body(WebSocketProcessor.catchAndCallOnError((Expr)cc.this_(), bc -> {
            Expr beanInstance = bc.invokeVirtual(MethodDesc.of(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[0]), (Expr)cc.this_());
            Expr[] args = callback.generateArguments((BlockCreator)bc, (Expr)cc.this_(), (Var)payload, transformedAnnotations, index);
            Expr ret = WebSocketProcessor.callBusinessMethod(bc, callback, beanInstance, args, (Expr)cc.this_(), invoker);
            WebSocketProcessor.encodeAndReturnResult(bc, (Expr)cc.this_(), callback, globalErrorHandlers, endpoint, ret, metricsSupportEnabled);
        }));
    }

    record GlobalErrorHandler(BeanInfo bean, Callback callback) {
    }

    private static final class EndpointSecurityChecksBuildItem
    extends SimpleBuildItem {
        private final Map<String, SecurityCheck> endpointIdToSecurityCheck;

        private EndpointSecurityChecksBuildItem(Map<String, SecurityCheck> endpointIdToSecurityCheck) {
            this.endpointIdToSecurityCheck = endpointIdToSecurityCheck;
        }
    }

    record ErrorHandler(BeanInfo bean, Callback callback, FieldDesc invoker, List<DotName> hierarchy) {
        public int level() {
            return this.hierarchy.size();
        }
    }
}

